/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.camel.component.properties.PropertiesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesParser
implements PropertiesParser {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
        String answer = text;
        boolean done = false;
        ArrayList<String> visited = new ArrayList<String>();
        while (!done) {
            ArrayList<String> replaced = new ArrayList<String>();
            answer = this.doParseUri(answer, properties, replaced, prefixToken, suffixToken);
            for (String replace : replaced) {
                if (!visited.contains(replace)) continue;
                throw new IllegalArgumentException("Circular reference detected with key [" + replace + "] from text: " + text);
            }
            visited.addAll(replaced);
            done = !answer.contains(prefixToken);
        }
        return answer;
    }

    @Override
    public String parseProperty(String key, String value, Properties properties) {
        return value;
    }

    private String doParseUri(String uri, Properties properties, List<String> replaced, String prefixToken, String suffixToken) {
        StringBuilder sb = new StringBuilder();
        int pivot = 0;
        int size = uri.length();
        while (pivot < size) {
            int endIdx;
            int idx = uri.indexOf(prefixToken, pivot);
            if (idx < 0) {
                sb.append(this.createConstantPart(uri, pivot, size));
                break;
            }
            if (pivot < idx) {
                sb.append(this.createConstantPart(uri, pivot, idx));
            }
            if ((endIdx = uri.indexOf(suffixToken, pivot = idx + prefixToken.length())) < 0) {
                throw new IllegalArgumentException("Expecting " + suffixToken + " but found end of string from text: " + uri);
            }
            String key = uri.substring(pivot, endIdx);
            String part = this.createPlaceholderPart(key, properties, replaced);
            if (part == null) {
                throw new IllegalArgumentException("Property with key [" + key + "] not found in properties from text: " + uri);
            }
            sb.append(part);
            pivot = endIdx + suffixToken.length();
        }
        return sb.toString();
    }

    private String createConstantPart(String uri, int start, int end) {
        return uri.substring(start, end);
    }

    private String createPlaceholderPart(String key, Properties properties, List<String> replaced) {
        replaced.add(key);
        String propertyValue = System.getProperty(key);
        if (propertyValue != null) {
            this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)propertyValue);
        } else if (properties != null) {
            propertyValue = properties.getProperty(key);
        }
        return this.parseProperty(key, propertyValue, properties);
    }
}

