/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.xml.TimeUnitAdapter;
import org.apache.camel.impl.ThreadPoolProfileSupport;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="threadPoolProfile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreadPoolProfileDefinition
extends OptionalIdentifiedDefinition {
    @XmlAttribute
    private Boolean defaultProfile;
    @XmlAttribute
    private String poolSize;
    @XmlAttribute
    private String maxPoolSize;
    @XmlAttribute
    private String keepAliveTime;
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private TimeUnit timeUnit;
    @XmlAttribute
    private String maxQueueSize;
    @XmlAttribute
    private ThreadPoolRejectedPolicy rejectedPolicy;

    public ThreadPoolProfileDefinition() {
    }

    public ThreadPoolProfileDefinition(ThreadPoolProfile threadPoolProfile) {
        this.setDefaultProfile(threadPoolProfile.isDefaultProfile());
        this.setPoolSize("" + threadPoolProfile.getPoolSize());
        this.setMaxPoolSize("" + threadPoolProfile.getMaxPoolSize());
        this.setKeepAliveTime("" + threadPoolProfile.getKeepAliveTime());
        this.setTimeUnit(threadPoolProfile.getTimeUnit());
        this.setMaxQueueSize("" + threadPoolProfile.getMaxQueueSize());
        this.setRejectedPolicy(threadPoolProfile.getRejectedPolicy());
    }

    public ThreadPoolProfileDefinition poolSize(int poolSize) {
        return this.poolSize("" + poolSize);
    }

    public ThreadPoolProfileDefinition poolSize(String poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }

    public ThreadPoolProfileDefinition maxPoolSize(int maxPoolSize) {
        return this.maxPoolSize("" + this.maxQueueSize);
    }

    public ThreadPoolProfileDefinition maxPoolSize(String maxPoolSize) {
        this.setMaxPoolSize("" + maxPoolSize);
        return this;
    }

    public ThreadPoolProfileDefinition keepAliveTime(long keepAliveTime) {
        return this.keepAliveTime("" + keepAliveTime);
    }

    public ThreadPoolProfileDefinition keepAliveTime(String keepAliveTime) {
        this.setKeepAliveTime("" + keepAliveTime);
        return this;
    }

    public ThreadPoolProfileDefinition timeUnit(TimeUnit timeUnit) {
        this.setTimeUnit(timeUnit);
        return this;
    }

    public ThreadPoolProfileDefinition maxQueueSize(int maxQueueSize) {
        return this.maxQueueSize("" + maxQueueSize);
    }

    public ThreadPoolProfileDefinition maxQueueSize(String maxQueueSize) {
        this.setMaxQueueSize("" + maxQueueSize);
        return this;
    }

    public ThreadPoolProfileDefinition rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.setRejectedPolicy(rejectedPolicy);
        return this;
    }

    public Boolean getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(Boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public Boolean isDefaultProfile() {
        return this.defaultProfile != null && this.defaultProfile != false;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(String keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        if (this.rejectedPolicy != null) {
            return this.rejectedPolicy.asRejectedExecutionHandler();
        }
        return null;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public ThreadPoolProfile asThreadPoolProfile(CamelContext context) throws Exception {
        ObjectHelper.notNull(context, "CamelContext", this);
        ThreadPoolProfileSupport answer = new ThreadPoolProfileSupport(this.getId());
        answer.setDefaultProfile(this.getDefaultProfile());
        answer.setPoolSize(CamelContextHelper.parseInteger(context, this.getPoolSize()));
        answer.setMaxPoolSize(CamelContextHelper.parseInteger(context, this.getMaxPoolSize()));
        answer.setKeepAliveTime(CamelContextHelper.parseLong(context, this.getKeepAliveTime()));
        answer.setMaxQueueSize(CamelContextHelper.parseInteger(context, this.getMaxQueueSize()));
        answer.setRejectedPolicy(this.getRejectedPolicy());
        answer.setTimeUnit(this.getTimeUnit());
        return answer;
    }
}

