/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TryProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable {
    private static final transient Logger LOG = LoggerFactory.getLogger(TryProcessor.class);
    protected final AsyncProcessor tryProcessor;
    protected final DoCatchProcessor catchProcessor;
    protected final DoFinallyProcessor finallyProcessor;
    private List<AsyncProcessor> processors;

    public TryProcessor(Processor tryProcessor, List<CatchProcessor> catchClauses, Processor finallyProcessor) {
        this.tryProcessor = AsyncProcessorTypeConverter.convert(tryProcessor);
        this.catchProcessor = new DoCatchProcessor(catchClauses);
        this.finallyProcessor = new DoFinallyProcessor(finallyProcessor);
    }

    public String toString() {
        String finallyText = this.finallyProcessor == null ? "" : " Finally {" + this.finallyProcessor + "}";
        return "Try {" + this.tryProcessor + "} " + (this.catchProcessor != null ? this.catchProcessor : "") + finallyText;
    }

    @Override
    public String getTraceLabel() {
        return "doTry";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Iterator<AsyncProcessor> processors = this.getProcessors().iterator();
        while (this.continueRouting(processors, exchange)) {
            ExchangeHelper.prepareOutToIn(exchange);
            AsyncProcessor processor = processors.next();
            boolean sync = this.process(exchange, callback, processor, processors);
            if (!sync) {
                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                return false;
            }
            LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
        }
        ExchangeHelper.prepareOutToIn(exchange);
        LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        callback.done(true);
        return true;
    }

    protected boolean process(final Exchange exchange, final AsyncCallback callback, AsyncProcessor processor, final Iterator<AsyncProcessor> processors) {
        LOG.trace("Processing exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        boolean sync = AsyncProcessorHelper.process(processor, exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                while (TryProcessor.this.continueRouting(processors, exchange)) {
                    ExchangeHelper.prepareOutToIn(exchange);
                    AsyncProcessor processor = (AsyncProcessor)processors.next();
                    doneSync = TryProcessor.this.process(exchange, callback, processor, processors);
                    if (doneSync) continue;
                    LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                    return;
                }
                ExchangeHelper.prepareOutToIn(exchange);
                LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                callback.done(false);
            }
        });
        return sync;
    }

    protected Collection<AsyncProcessor> getProcessors() {
        return this.processors;
    }

    protected boolean continueRouting(Iterator<AsyncProcessor> it, Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop).booleanValue())) {
            LOG.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        return it.hasNext();
    }

    @Override
    protected void doStart() throws Exception {
        this.processors = new ArrayList<AsyncProcessor>();
        this.processors.add(this.tryProcessor);
        this.processors.add(this.catchProcessor);
        this.processors.add(this.finallyProcessor);
        ServiceHelper.startServices(this.tryProcessor, this.catchProcessor, this.finallyProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.finallyProcessor, this.catchProcessor, this.tryProcessor);
        this.processors.clear();
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.tryProcessor != null) {
            answer.add(this.tryProcessor);
        }
        if (this.catchProcessor != null) {
            answer.add(this.catchProcessor);
        }
        if (this.finallyProcessor != null) {
            answer.add(this.finallyProcessor);
        }
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.tryProcessor != null;
    }

    private final class HandleDoCatchProcessor
    extends DelegateAsyncProcessor {
        private final CatchProcessor catchClause;

        private HandleDoCatchProcessor(CatchProcessor processor) {
            super(processor);
            this.catchClause = processor;
        }

        @Override
        protected boolean processNext(final Exchange exchange, final AsyncCallback callback) {
            boolean sync;
            Exception caught = exchange.getException();
            if (caught == null) {
                return true;
            }
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            exchange.setProperty("CamelExceptionCaught", caught);
            exchange.setException(null);
            final Boolean handled = this.catchClause.handles(exchange);
            if (LOG.isDebugEnabled()) {
                LOG.debug("The exception is handled: {} for the exception: {} caused by: {}", new Object[]{handled, caught.getClass().getName(), caught.getMessage()});
            }
            if ((sync = super.processNext(exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    if (doneSync) {
                        return;
                    }
                    if (!handled.booleanValue() && exchange.getException() == null) {
                        exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
                    }
                    ExchangeHelper.prepareOutToIn(exchange);
                    callback.done(false);
                }
            })) && !handled.booleanValue() && exchange.getException() == null) {
                exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
            }
            return sync;
        }
    }

    private final class DoFinallyProcessor
    extends DelegateAsyncProcessor
    implements Traceable {
        private DoFinallyProcessor(Processor processor) {
            super(processor);
        }

        @Override
        protected boolean processNext(final Exchange exchange, final AsyncCallback callback) {
            final Exception e = exchange.getException();
            exchange.setException(null);
            if (e != null) {
                exchange.setProperty("CamelExceptionCaught", e);
            }
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            boolean sync = super.processNext(exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    if (doneSync) {
                        return;
                    }
                    if (e != null) {
                        exchange.setException(e);
                        exchange.setProperty("CamelExceptionCaught", e);
                    }
                    ExchangeHelper.prepareOutToIn(exchange);
                    LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                    callback.done(false);
                }
            });
            if (sync && e != null) {
                exchange.setException(e);
                exchange.setProperty("CamelExceptionCaught", e);
            }
            return sync;
        }

        @Override
        public String toString() {
            return "Finally{" + this.getProcessor() + "}";
        }

        @Override
        public String getTraceLabel() {
            return "doFinally";
        }
    }

    private final class DoCatchProcessor
    extends ServiceSupport
    implements AsyncProcessor,
    Navigate<Processor>,
    Traceable {
        private final List<CatchProcessor> catchClauses;

        private DoCatchProcessor(List<CatchProcessor> catchClauses) {
            this.catchClauses = catchClauses;
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            AsyncProcessorHelper.process(this, exchange);
        }

        @Override
        public boolean process(Exchange exchange, AsyncCallback callback) {
            Exception e = exchange.getException();
            if (this.catchClauses == null || e == null) {
                return true;
            }
            CatchProcessor processor = null;
            for (CatchProcessor catchClause : this.catchClauses) {
                Throwable caught = catchClause.catches(exchange, e);
                if (caught == null) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("This TryProcessor catches the exception: {} caused by: {}", (Object)caught.getClass().getName(), (Object)e.getMessage());
                }
                processor = catchClause;
                break;
            }
            if (processor != null) {
                HandleDoCatchProcessor cool = new HandleDoCatchProcessor(processor);
                return AsyncProcessorHelper.process(cool, exchange, callback);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("This TryProcessor does not catch the exception: {} caused by: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
            return true;
        }

        @Override
        protected void doStart() throws Exception {
            ServiceHelper.startService(this.catchClauses);
        }

        @Override
        protected void doStop() throws Exception {
            ServiceHelper.stopServices(this.catchClauses);
        }

        public String toString() {
            return "Catches{" + this.catchClauses + "}";
        }

        @Override
        public String getTraceLabel() {
            return "doCatch";
        }

        @Override
        public List<Processor> next() {
            ArrayList<Processor> answer = new ArrayList<Processor>();
            if (TryProcessor.this.catchProcessor != null) {
                answer.addAll(this.catchClauses);
            }
            return answer;
        }

        @Override
        public boolean hasNext() {
            return this.catchClauses != null && this.catchClauses.size() > 0;
        }
    }
}

