/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;

public class SwitchYardConsumer
extends DefaultConsumer
implements ExchangeHandler {
    public SwitchYardConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public void handleMessage(Exchange switchyardExchange) throws HandlerException {
        org.apache.camel.Exchange camelExchange = this.createCamelExchange(switchyardExchange);
        this.invokeCamelProcessor(camelExchange);
        this.handleExceptionsFromCamel(camelExchange);
        if (this.isInOut(switchyardExchange)) {
            this.sendResponse(camelExchange, switchyardExchange);
        }
    }

    private void invokeCamelProcessor(org.apache.camel.Exchange camelExchange) throws HandlerException {
        try {
            this.getProcessor().process(camelExchange);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private void handleExceptionsFromCamel(org.apache.camel.Exchange camelExchange) throws HandlerException {
        Exception camelException = camelExchange.getException();
        if (camelException != null) {
            throw new HandlerException((Throwable)camelException);
        }
        Message message = camelExchange.getOut();
        if (message.isFault()) {
            throw new HandlerException(message.getBody(String.class));
        }
    }

    private org.apache.camel.Exchange createCamelExchange(Exchange switchyardExchange) {
        org.apache.camel.Exchange camelExchange = this.isInOut(switchyardExchange) ? this.getEndpoint().createExchange(org.apache.camel.ExchangePattern.InOut) : this.getEndpoint().createExchange(org.apache.camel.ExchangePattern.InOnly);
        camelExchange.getIn().setBody(switchyardExchange.getMessage().getContent());
        return camelExchange;
    }

    private void sendResponse(org.apache.camel.Exchange camelExchange, Exchange switchyardExchange) {
        Object payload = camelExchange.getOut().getBody();
        if (payload == null) {
            payload = camelExchange.getIn().getBody();
        }
        switchyardExchange.getMessage().setContent(payload);
        switchyardExchange.send(switchyardExchange.getMessage());
    }

    private boolean isInOut(Exchange exchange) {
        return exchange.getContract().getServiceOperation().getExchangePattern() == ExchangePattern.IN_OUT;
    }

    public void handleFault(Exchange exchange) {
    }
}

