/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.cdi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.Registry;
import org.apache.log4j.Logger;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.CDIBean;
import org.switchyard.exception.SwitchYardException;

public class CDIAwareRegistry
implements Registry {
    private static Logger _logger = Logger.getLogger(CDIAwareRegistry.class);
    private BeanDeploymentMetaData _beanDeploymentMetaData;
    private Registry _baseRegistry;

    public CDIAwareRegistry() {
        try {
            this._beanDeploymentMetaData = BeanDeploymentMetaData.lookupBeanDeploymentMetaData();
        }
        catch (SwitchYardException e) {
            _logger.debug((Object)"CDIAwareRegistry falling back to default Jndi only Registry behavior.  Deployment does not contain bean metadata.");
        }
        this._baseRegistry = new JndiRegistry();
    }

    @Override
    public Object lookup(String name) {
        Bean<?> bean;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Looking up bean using name = [" + name + "] in CDI registry ..."));
        }
        if ((bean = this.getBean(name)) == null) {
            return this._baseRegistry.lookup(name);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Found SwitchYard Service bean matching name = [" + name + "] in CDI registry."));
        }
        return this.createBeanInstance(bean);
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Looking up bean using name = [" + name + "] having expected type = [" + type.getName() + "] in CDI registry ..."));
        }
        return type.cast(this.lookup(name));
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        List<CDIBean> serviceBeans;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Looking up all beans having expected type = [" + type.getName() + "] in CDI registry ..."));
        }
        if ((serviceBeans = this.getBeans(type)).isEmpty()) {
            return this._baseRegistry.lookupByType(type);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Found [" + Integer.valueOf(serviceBeans.size()) + "] beans having expected type = [" + type.getName() + "] in CDI registry."));
        }
        HashMap<String, T> beansByName = new HashMap<String, T>(serviceBeans.size());
        for (CDIBean cdiBean : serviceBeans) {
            String beanName = cdiBean.getBean().getName();
            if (beanName == null) continue;
            beansByName.put(beanName, type.cast(this.createBeanInstance(cdiBean.getBean())));
        }
        return beansByName;
    }

    private Bean<?> getBean(String name) {
        Set beans;
        if (this._beanDeploymentMetaData != null && (beans = this._beanDeploymentMetaData.getBeanManager().getBeans(name)) != null && !beans.isEmpty()) {
            return (Bean)beans.iterator().next();
        }
        return null;
    }

    private List<CDIBean> getBeans(Class<?> type) {
        ArrayList<CDIBean> cdiBeans = new ArrayList<CDIBean>();
        if (this._beanDeploymentMetaData != null) {
            for (CDIBean cdiBean : this._beanDeploymentMetaData.getDeploymentBeans()) {
                if (!type.isAssignableFrom(cdiBean.getBean().getBeanClass())) continue;
                cdiBeans.add(cdiBean);
            }
        }
        return cdiBeans;
    }

    private Object createBeanInstance(Bean bean) {
        BeanManager beanManager = this._beanDeploymentMetaData.getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        return beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
    }
}

