/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.camel;

import java.net.URI;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.camel.config.model.v1.V1CamelBindingModel;
import org.switchyard.component.camel.config.model.v1.V1OperationSelector;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.forge.camel.CamelFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;

@Alias(value="camel-binding")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, CamelFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage Camel service bindings in SwitchYard.")
public class CamelBindingPlugin
implements Plugin {
    @Inject
    private Project _project;

    @Command(value="bind-service", help="Add a Camel binding to a service.")
    public void bindService(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=true, name="configURI", description="The configuration URI") String configURI, @Option(required=false, name="operationName", description="The operation name") String operationName, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = switchYard.getCompositeService(serviceName);
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "No public service named: " + serviceName));
            return;
        }
        V1CamelBindingModel binding = new V1CamelBindingModel();
        binding.setConfigURI(URI.create(configURI));
        if (operationName != null) {
            V1OperationSelector operation = new V1OperationSelector();
            operation.setOperationName(operationName);
            binding.setOperationSelector(operation);
        }
        service.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.camel to service " + serviceName);
    }

    @Command(value="bind-reference", help="Add a Camel binding to a reference.")
    public void bindReference(@Option(required=true, name="referenceName", description="The reference name") String referenceName, @Option(required=true, name="configURI", description="The configuration URI") String configURI, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeReferenceModel reference = switchYard.getCompositeReference(referenceName);
        if (reference == null) {
            out.println(out.renderColor(ShellColor.RED, "No public reference named: " + referenceName));
            return;
        }
        V1CamelBindingModel binding = new V1CamelBindingModel();
        binding.setConfigURI(URI.create(configURI));
        reference.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.camel to reference " + referenceName);
    }
}

