/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.camel;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.apache.camel.builder.RouteBuilder;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.camel.Route;
import org.switchyard.component.camel.config.model.v1.V1CamelImplementationModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.forge.camel.CamelFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;

@Alias(value="camel-service")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, CamelFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to create and edit Camel routes in SwitchYard.")
public class CamelServicePlugin
implements Plugin {
    private static final String SERVICE_TOKEN = "${service.name}";
    private static final String ROUTE_TEMPLATE = "public void configure() {\nfrom(\"switchyard://${service.name}\")}";
    @Inject
    private Project _project;
    @Inject
    private Shell _shell;

    @Command(value="create", help="Created a new Camel service.")
    public void newRoute(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=false, name="type", description="Route type") String routeType, PipeOut out) throws FileNotFoundException {
        RouteType type = RouteType.fromString(routeType);
        if (type == null || type == RouteType.JAVA) {
            this.createJavaRoute(serviceName, out);
        } else if (RouteType.XML == type) {
            this.createXMLRoute(serviceName);
        }
        out.println("Created Camel service " + serviceName);
    }

    private void createXMLRoute(String routeName) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        V1ComponentModel component = new V1ComponentModel();
        component.setName(routeName + "Component");
        V1ComponentServiceModel service = new V1ComponentServiceModel();
        service.setName(routeName);
        component.addService((ComponentServiceModel)service);
        V1CamelImplementationModel impl = new V1CamelImplementationModel();
        component.setImplementation((ComponentImplementationModel)impl);
        SwitchYardModel syConfig = switchYard.getSwitchYardConfig();
        syConfig.getComposite().addComponent((ComponentModel)component);
        switchYard.saveConfig();
    }

    private void createJavaRoute(String routeName, PipeOut out) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)this._shell.getCurrentProject().getFacet(JavaSourceFacet.class);
        String pkgName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getTopLevelPackage();
        if (pkgName == null) {
            pkgName = this._shell.promptCommon("Java package for route interface and implementation:", PromptType.JAVA_PACKAGE);
        }
        JavaInterface routeInterface = (JavaInterface)((JavaInterface)((JavaInterface)((JavaInterface)JavaParser.create(JavaInterface.class)).setPackage(pkgName)).setName(routeName)).setPublic();
        java.saveJavaSource((JavaSource)routeInterface);
        JavaClass routeClass = (JavaClass)((JavaClass)((JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setPackage(pkgName)).setName(routeName + "Builder")).setSuperType(RouteBuilder.class)).setPublic();
        Annotation routeAnnotation = routeClass.addAnnotation(Route.class);
        routeAnnotation.setLiteralValue(routeInterface.getName() + ".class");
        routeClass.addMethod(ROUTE_TEMPLATE.replace(SERVICE_TOKEN, routeInterface.getName()));
        java.saveJavaSource((JavaSource)routeClass);
        out.println("Created route interface [" + routeInterface.getName() + "]");
        out.println("Created route implementation [" + routeClass.getName() + "]");
        out.println(out.renderColor(ShellColor.BLUE, "NOTE: Run 'mvn package' to make " + routeName + " visible to SwitchYard shell."));
    }

    private static enum RouteType {
        JAVA,
        XML;


        static RouteType fromString(String typeStr) {
            if (JAVA.toString().equalsIgnoreCase(typeStr)) {
                return JAVA;
            }
            if (XML.toString().equalsIgnoreCase(typeStr)) {
                return XML;
            }
            return null;
        }
    }
}

