/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.FrameworkException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public abstract class FrameworkIntegrationBean {
    private static final Logger log = Logger.getLogger(FrameworkIntegrationBean.class);
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<URL> autoInstall = new ArrayList<URL>();
    private List<URL> autoStart = new ArrayList<URL>();
    private Framework framework;

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    public List<URL> getAutoInstall() {
        return this.autoInstall;
    }

    public void setAutoInstall(List<URL> autoInstall) {
        this.autoInstall = autoInstall;
    }

    public List<URL> getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(List<URL> autoStart) {
        this.autoStart = autoStart;
    }

    public Bundle getBundle() {
        this.assertFrameworkStart();
        return this.getFramework();
    }

    public BundleContext getBundleContext() {
        this.assertFrameworkStart();
        return this.getFramework().getBundleContext();
    }

    public Framework getFramework() {
        if (this.framework == null) {
            this.framework = this.createFramework(this.properties);
        }
        return this.framework;
    }

    public void create() {
        if (this.framework == null) {
            this.framework = this.createFramework(this.properties);
        }
    }

    protected abstract Framework createFramework(Map<String, Object> var1);

    public void start() {
        Bundle bundle;
        this.assertFrameworkCreate();
        try {
            this.getFramework().start();
        }
        catch (BundleException ex) {
            throw new FrameworkException("Cannot start system bundle", ex);
        }
        BundleContext context = this.getFramework().getBundleContext();
        if (context == null) {
            throw new FrameworkException("Cannot obtain system context");
        }
        HashMap<URL, Bundle> autoBundles = new HashMap<URL, Bundle>();
        for (URL bundleURL : this.autoStart) {
            this.autoInstall.add(bundleURL);
        }
        this.registerSystemServices(context);
        for (URL bundleURL : this.autoInstall) {
            try {
                bundle = context.installBundle(bundleURL.toString());
                long bundleId = bundle.getBundleId();
                log.info((Object)("Installed bundle [" + bundleId + "]: " + bundle.getSymbolicName()));
                autoBundles.put(bundleURL, bundle);
            }
            catch (BundleException ex) {
                this.stop();
                throw new IllegalStateException("Cannot install bundle: " + bundleURL, ex);
            }
        }
        for (URL bundleURL : this.autoStart) {
            try {
                bundle = (Bundle)autoBundles.get(bundleURL);
                if (bundle == null) continue;
                bundle.start();
                log.info((Object)("Started bundle: " + bundle.getSymbolicName()));
            }
            catch (BundleException ex) {
                this.stop();
                throw new IllegalStateException("Cannot start bundle: " + bundleURL, ex);
            }
        }
    }

    public void stop() {
        Framework framework = this.getFramework();
        if (framework != null) {
            this.unregisterSystemServices(this.getBundleContext());
            try {
                framework.stop();
                framework.waitForStop(5000L);
                framework = null;
                log.debug((Object)"SystemBundle STOPPED");
            }
            catch (BundleException ex) {
                log.error((Object)"Cannot stop Framework", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                log.error((Object)"Cannot stop Framework", (Throwable)ex);
            }
        }
    }

    protected void registerSystemServices(BundleContext context) {
    }

    protected void unregisterSystemServices(BundleContext context) {
    }

    private void assertFrameworkCreate() {
        if (this.getFramework() == null) {
            this.create();
        }
    }

    private void assertFrameworkStart() {
        this.assertFrameworkCreate();
        if ((this.getFramework().getState() & 0x20) == 0) {
            this.start();
        }
    }
}

