/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossExecutors;

public final class ScheduledThreadPoolService
implements Service<ScheduledExecutorService> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private ScheduledThreadPoolExecutor executor;
    private ScheduledExecutorService value;
    private StopContext context;
    private final int maxThreads;
    private final TimeSpec keepAlive;

    public ScheduledThreadPoolService(int maxThreads, TimeSpec keepAlive) {
        this.maxThreads = maxThreads;
        this.keepAlive = keepAlive;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.executor = new ExecutorImpl(0, (ThreadFactory)this.threadFactoryValue.getValue());
        this.executor.setCorePoolSize(this.maxThreads);
        if (this.keepAlive != null) {
            this.executor.setKeepAliveTime(this.keepAlive.getDuration(), this.keepAlive.getUnit());
        }
        this.value = JBossExecutors.protectedScheduledExecutorService((ScheduledExecutorService)this.executor);
    }

    public synchronized void stop(StopContext context) {
        ScheduledThreadPoolExecutor executor = this.executor;
        if (executor == null) {
            throw new IllegalStateException();
        }
        this.context = context;
        context.asynchronous();
        executor.shutdown();
        this.executor = null;
        this.value = null;
    }

    public synchronized ScheduledExecutorService getValue() throws IllegalStateException {
        ScheduledExecutorService value = this.value;
        if (value == null) {
            throw new IllegalStateException();
        }
        return value;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    private class ExecutorImpl
    extends ScheduledThreadPoolExecutor {
        ExecutorImpl(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void terminated() {
            ScheduledThreadPoolService scheduledThreadPoolService = ScheduledThreadPoolService.this;
            synchronized (scheduledThreadPoolService) {
                super.terminated();
                ScheduledThreadPoolService.this.context.complete();
                ScheduledThreadPoolService.this.context = null;
            }
        }
    }
}

