/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class LoopbackAddressInterfaceCriteria
implements InterfaceCriteria {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private static final long serialVersionUID = 1L;
    private ModelNode address;
    private InetAddress resolved;
    private boolean unknownHostLogged;
    private boolean anyLocalLogged;

    public LoopbackAddressInterfaceCriteria(ModelNode address) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        this.address = address;
    }

    public synchronized InetAddress getAddress() throws UnknownHostException {
        if (this.resolved == null) {
            this.resolved = InetAddress.getByName(this.address.resolve().asString());
        }
        return this.resolved;
    }

    @Override
    public InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        block3: {
            try {
                if (networkInterface.isLoopback()) {
                    InetAddress resolved = this.getAddress();
                    return resolved;
                }
            }
            catch (UnknownHostException e) {
                if (this.unknownHostLogged) break block3;
                log.warnf("Cannot resolve address %s, so cannot match it to any InetAddress", (Object)this.address);
                this.unknownHostLogged = true;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LoopbackAddressInterfaceCriteria(");
        sb.append("address=");
        sb.append(this.address);
        sb.append(",resolved=");
        sb.append(this.resolved);
        sb.append(')');
        return sb.toString();
    }
}

