/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ExtensionDescription;
import org.jboss.dmr.ModelNode;

public abstract class AbstractExtensionAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";

    public static ModelNode getAddExtensionOperation(ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        return op;
    }

    protected AbstractExtensionAddHandler() {
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String module = address.getLastElement().getValue();
        model.get("module").set(module);
        this.installExtension(module, model);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return ExtensionDescription.getExtensionAddOperation(locale);
    }

    protected abstract void installExtension(String var1, ModelNode var2) throws OperationFailedException;

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }
}

