/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class StringLengthValidator
extends ModelTypeValidator {
    protected final int min;
    protected final int max;

    public StringLengthValidator(int min) {
        this(min, Integer.MAX_VALUE, false, false);
    }

    public StringLengthValidator(int min, boolean nullable) {
        this(min, Integer.MAX_VALUE, nullable, false);
    }

    public StringLengthValidator(int min, int max, boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions, false);
        this.min = min;
        this.max = max;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            String str = value.asString();
            if (str.length() < this.min) {
                throw new OperationFailedException(new ModelNode().set("\"" + str + "\" is an invalid value for parameter " + parameterName + ". Values must have a minimum length of " + this.min + " characters"));
            }
            if (str.length() > this.max) {
                throw new OperationFailedException(new ModelNode().set("\"" + str + "\" is an invalid value for parameter " + parameterName + ". Values must have a maximum length of " + this.max + " characters"));
            }
        }
    }
}

