/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.Set;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.ConcurrentGroupServerUpdatePolicy;
import org.jboss.dmr.ModelNode;

class ServerUpdatePolicy {
    private final ConcurrentGroupServerUpdatePolicy parent;
    private final String serverGroupName;
    private final Set<ServerIdentity> servers;
    private int successCount;
    private int failureCount;
    private final int maxFailed;

    ServerUpdatePolicy(ConcurrentGroupServerUpdatePolicy parent, String serverGroupName, Set<ServerIdentity> servers, int maxFailures) {
        assert (parent != null) : "parent is null";
        assert (serverGroupName != null) : "serverGroupName is null";
        assert (servers != null) : "servers is null";
        this.parent = parent;
        this.serverGroupName = serverGroupName;
        this.servers = servers;
        this.maxFailed = maxFailures;
    }

    ServerUpdatePolicy(ConcurrentGroupServerUpdatePolicy parent, String serverGroupName, Set<ServerIdentity> servers) {
        assert (parent != null) : "parent is null";
        assert (serverGroupName != null) : "serverGroupName is null";
        assert (servers != null) : "servers is null";
        this.parent = parent;
        this.serverGroupName = serverGroupName;
        this.servers = servers;
        this.maxFailed = servers.size();
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUpdateServer(ServerIdentity server) {
        if (!this.serverGroupName.equals(server.getServerGroupName()) || !this.servers.contains(server)) {
            throw new IllegalStateException("Unknown server " + server);
        }
        if (!this.parent.canChildProceed()) {
            return false;
        }
        ServerUpdatePolicy serverUpdatePolicy = this;
        synchronized (serverUpdatePolicy) {
            return this.failureCount <= this.maxFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordServerResult(ServerIdentity server, ModelNode response) {
        if (!this.serverGroupName.equals(server.getServerGroupName()) || !this.servers.contains(server)) {
            throw new IllegalStateException("Unknown server " + server);
        }
        boolean serverFailed = response.has("failure-description");
        ServerUpdatePolicy serverUpdatePolicy = this;
        synchronized (serverUpdatePolicy) {
            int previousFailed = this.failureCount++;
            if (!serverFailed) {
                ++this.successCount;
            }
            if (previousFailed <= this.maxFailed) {
                if (!serverFailed && this.successCount + this.failureCount == this.servers.size()) {
                    this.parent.recordServerGroupResult(this.serverGroupName, false);
                } else if (serverFailed && this.failureCount > this.maxFailed) {
                    this.parent.recordServerGroupResult(this.serverGroupName, true);
                }
            }
        }
    }

    public synchronized boolean isFailed() {
        return this.failureCount > this.maxFailed;
    }
}

