/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class BasicComponentInstance
implements ComponentInstance {
    private static final long serialVersionUID = -8099216228976950066L;
    private static final Logger log = Logger.getLogger(BasicComponentInstance.class);
    public static final Object INSTANCE_KEY = new Object();
    private final BasicComponent component;
    private final AtomicReference<ManagedReference> instanceReference;
    private final Interceptor preDestroy;
    private volatile int done;
    private static final AtomicIntegerFieldUpdater<BasicComponentInstance> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(BasicComponentInstance.class, "done");
    private final Map<Method, Interceptor> methodMap;

    protected BasicComponentInstance(BasicComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        this.component = component;
        this.instanceReference = instanceReference;
        this.preDestroy = preDestroyInterceptor;
        this.methodMap = Collections.unmodifiableMap(methodInterceptors);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Object getInstance() {
        ManagedReference managedReference = this.instanceReference.get();
        return managedReference.getInstance();
    }

    @Override
    public Interceptor getInterceptor(Method method) throws IllegalStateException {
        Interceptor interceptor = this.methodMap.get(method);
        if (interceptor == null) {
            throw new IllegalStateException("Method does not exist " + method);
        }
        return interceptor;
    }

    @Override
    public Collection<Method> allowedMethods() {
        return this.methodMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (doneUpdater.compareAndSet(this, 0, 1)) {
            try {
                InterceptorContext interceptorContext = new InterceptorContext();
                interceptorContext.putPrivateData(Component.class, (Object)this.component);
                interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
                this.preDestroy.processInvocation(interceptorContext);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to destroy component instance " + this), (Throwable)e);
            }
            finally {
                this.component.finishDestroy();
            }
        }
    }

    protected void finalize() {
        this.destroy();
    }
}

