/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;

public class LazyResourceInjection {
    private final EEModuleClassDescription classDescription;
    private final InjectionTarget injectionTarget;
    private final String localContextName;
    private boolean installed = false;

    public LazyResourceInjection(InjectionTarget injectionTarget, String localContextName, EEModuleClassDescription classDescription) {
        this.injectionTarget = injectionTarget;
        this.localContextName = localContextName;
        this.classDescription = classDescription;
    }

    public void install() {
        if (!this.installed) {
            ResourceInjectionConfiguration resource = new ResourceInjectionConfiguration(this.injectionTarget, new LookupInjectionSource(this.localContextName));
            this.classDescription.getConfigurators().add(new InjectionConfigrator(resource));
            this.installed = true;
        }
    }

    public String getLocalContextName() {
        return this.localContextName;
    }

    private static class InjectionConfigrator
    implements ClassConfigurator {
        private final ResourceInjectionConfiguration injectionConfiguration;

        public InjectionConfigrator(ResourceInjectionConfiguration injectionConfiguration) {
            this.injectionConfiguration = injectionConfiguration;
        }

        @Override
        public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
            configuration.getInjectionConfigurations().add(this.injectionConfiguration);
        }
    }
}

