/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public class ComponentFactoryImpl
extends AbstractComponentManager
implements ComponentFactory,
ComponentHolder {
    private final Map m_componentInstances = new IdentityHashMap();
    private Dictionary m_configuration;
    private Map m_configuredServices;
    private final boolean m_isConfigurationFactory;
    static /* synthetic */ Class class$org$osgi$service$component$ComponentFactory;

    public ComponentFactoryImpl(BundleComponentActivator activator, ComponentMetadata metadata) {
        super(activator, metadata);
        this.m_isConfigurationFactory = activator.getConfiguration().isFactoryEnabled();
        this.m_configuration = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInstance newInstance(Dictionary dictionary) {
        ImmediateComponentManager cm = this.createComponentManager(true);
        cm.setFactoryProperties(dictionary);
        cm.reconfigure(this.m_configuration);
        cm.enableInternal();
        cm.activateInternal();
        ComponentInstance instance = cm.getComponentInstance();
        if (instance == null) {
            cm.dispose();
            throw new ComponentException("Failed activating component");
        }
        Map map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.put(cm, cm);
        }
        return instance;
    }

    protected boolean createComponent() {
        ImmediateComponentManager[] cms = this.getComponentManagers(this.m_configuredServices);
        for (int i = 0; i < cms.length; ++i) {
            cms[i].enable();
        }
        return true;
    }

    protected void deleteComponent(int reason) {
        ImmediateComponentManager[] cms = this.getComponentManagers(this.m_configuredServices);
        for (int i = 0; i < cms.length; ++i) {
            cms[i].disable();
        }
    }

    protected ServiceRegistration registerService() {
        this.log(4, "registering component factory", null);
        Dictionary serviceProperties = this.getProperties();
        return this.getActivator().getBundleContext().registerService(new String[]{(class$org$osgi$service$component$ComponentFactory == null ? (class$org$osgi$service$component$ComponentFactory = ComponentFactoryImpl.class$("org.osgi.service.component.ComponentFactory")) : class$org$osgi$service$component$ComponentFactory).getName()}, this.getService(), serviceProperties);
    }

    public Object getInstance() {
        return null;
    }

    public boolean hasConfiguration() {
        return this.m_configuration != null;
    }

    public Dictionary getProperties() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("component.name", this.getComponentMetadata().getName());
        ((Dictionary)props).put("component.factory", this.getComponentMetadata().getFactoryIdentifier());
        ((Dictionary)props).put("service.pid", this.getComponentMetadata().getName());
        ((Dictionary)props).put("service.description", "ManagedServiceFactory for Factory Component" + this.getComponentMetadata().getName());
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        return props;
    }

    protected Object getService() {
        return this;
    }

    public ComponentInstance getComponentInstance() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationDeleted(String pid) {
        if (pid.equals(this.getComponentMetadata().getName())) {
            this.m_configuration = new Hashtable();
        } else if (this.m_isConfigurationFactory) {
            Map configuredServices = this.m_configuredServices;
            if (configuredServices != null) {
                ImmediateComponentManager cm;
                Map map = configuredServices;
                synchronized (map) {
                    cm = (ImmediateComponentManager)configuredServices.remove(pid);
                }
                if (cm != null) {
                    this.log(4, "Disposing component after configuration deletion", null);
                    cm.dispose();
                }
            }
        } else {
            this.log(1, "Component Factory cannot be configured by factory configuration", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationUpdated(String pid, Dictionary configuration) {
        if (pid.equals(this.getComponentMetadata().getName())) {
            this.m_configuration = configuration;
        } else if (this.m_isConfigurationFactory) {
            ImmediateComponentManager cm;
            Map map;
            Map configuredServices = this.m_configuredServices;
            if (configuredServices != null) {
                map = configuredServices;
                synchronized (map) {
                    cm = (ImmediateComponentManager)configuredServices.get(pid);
                }
            } else {
                this.m_configuredServices = new HashMap();
                configuredServices = this.m_configuredServices;
                cm = null;
            }
            if (cm == null) {
                cm = this.createComponentManager(false);
                cm.reconfigure(configuration);
                if (this.getState() == 64) {
                    cm.enable();
                }
                map = configuredServices;
                synchronized (map) {
                    configuredServices.put(pid, cm);
                }
            } else {
                cm.reconfigure(configuration);
            }
        } else {
            this.log(1, "Component Factory cannot be configured by factory configuration", null);
        }
    }

    public Component[] getComponents() {
        ImmediateComponentManager[] services;
        ImmediateComponentManager[] instances = this.getComponentManagers(this.m_componentInstances);
        int size = instances.length + (services = this.getComponentManagers(this.m_configuredServices)).length;
        if (size > 0) {
            Component[] result = new Component[size + 1];
            result[0] = this;
            System.arraycopy(instances, 0, result, 1, instances.length);
            System.arraycopy(services, 0, result, instances.length + 1, services.length);
            return result;
        }
        return new Component[]{this};
    }

    public void enableComponents() {
        this.enable();
    }

    public void disableComponents() {
        this.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponents(int reason) {
        ImmediateComponentManager[] cms = this.getComponentManagers(this.m_componentInstances);
        for (int i = 0; i < cms.length; ++i) {
            cms[i].dispose(reason);
        }
        Map i = this.m_componentInstances;
        synchronized (i) {
            this.m_componentInstances.clear();
        }
        cms = this.getComponentManagers(this.m_configuredServices);
        for (int i2 = 0; i2 < cms.length; ++i2) {
            cms[i2].dispose(reason);
        }
        this.m_configuredServices = null;
        this.dispose(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(ImmediateComponentManager component) {
        Map map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.remove(component);
        }
    }

    private ImmediateComponentManager createComponentManager(boolean newInstance) {
        if (newInstance) {
            return new ComponentFactoryNewInstance(this.getActivator(), this, this.getComponentMetadata());
        }
        return new ComponentFactoryConfiguredInstance(this.getActivator(), this, this.getComponentMetadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmediateComponentManager[] getComponentManagers(Map componentMap) {
        if (componentMap != null) {
            Map map = componentMap;
            synchronized (map) {
                ImmediateComponentManager[] cm = new ImmediateComponentManager[componentMap.size()];
                componentMap.values().toArray(cm);
                return cm;
            }
        }
        return new ImmediateComponentManager[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ComponentFactoryConfiguredInstance
    extends ImmediateComponentManager {
        public ComponentFactoryConfiguredInstance(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata) {
            super(activator, componentHolder, metadata);
        }
    }

    static class ComponentFactoryNewInstance
    extends ImmediateComponentManager {
        public ComponentFactoryNewInstance(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata) {
            super(activator, componentHolder, metadata);
        }
    }
}

