/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.registry.InstalledDriver;
import org.jboss.logging.Logger;

public class DriverRegistryImpl
implements DriverRegistry {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.connector.registry");
    private Map<String, InstalledDriver> drivers = new HashMap<String, InstalledDriver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInstalledDriver(InstalledDriver driver) throws IllegalArgumentException {
        if (driver == null) {
            throw new IllegalArgumentException("driver is null");
        }
        log.tracef("Adding driver: %s", (Object)driver);
        Map<String, InstalledDriver> map = this.drivers;
        synchronized (map) {
            this.drivers.put(driver.getDriverName(), driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterInstalledDriver(InstalledDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("driver is null");
        }
        log.tracef("Removing deployment: %s", (Object)driver);
        Map<String, InstalledDriver> map = this.drivers;
        synchronized (map) {
            this.drivers.put(driver.getDriverName(), driver);
        }
    }

    @Override
    public Set<InstalledDriver> getInstalledDrivers() {
        return Collections.unmodifiableSet(Collections.synchronizedSet(new HashSet<InstalledDriver>(this.drivers.values())));
    }

    @Override
    public InstalledDriver getInstalledDriver(String name) {
        return this.drivers.get(name);
    }
}

