/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class JPADependencyProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier JAVAX_PERSISTENCE_API_ID = ModuleIdentifier.create((String)"javax.persistence.api");
    private static ModuleIdentifier JAVAEE_API_ID = ModuleIdentifier.create((String)"javaee.api");
    private static ModuleIdentifier JBOSS_AS_JPA_ID = ModuleIdentifier.create((String)"org.jboss.as.jpa");
    private static ModuleIdentifier JBOSS_HIBERNATE_ID = ModuleIdentifier.create((String)"org.hibernate");
    private static ModuleIdentifier JAVASSIST_ID = ModuleIdentifier.create((String)"org.javassist");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, JAVAX_PERSISTENCE_API_ID);
        if (!JPADeploymentMarker.isJPADeployment(deploymentUnit)) {
            return;
        }
        this.addDependency(moduleSpecification, moduleLoader, JAVAEE_API_ID);
        this.addDependency(moduleSpecification, moduleLoader, JBOSS_AS_JPA_ID);
        this.addDependency(moduleSpecification, moduleLoader, JBOSS_HIBERNATE_ID);
        this.addDependency(moduleSpecification, moduleLoader, JAVASSIST_ID);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

