/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.EjbProcessorUtils;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.EjbNameThreadLocal;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorClassesMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;

public class InterceptorsProcessor<T extends AnnotatedElement>
extends AbstractFinderUser
implements Processor<InterceptorBindingsMetaData, T> {
    public InterceptorsProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(InterceptorBindingsMetaData metaData, T type) {
        Interceptors interceptors = (Interceptors)this.finder.getAnnotation(type, Interceptors.class);
        if (interceptors == null) {
            return;
        }
        ExcludeClassInterceptors excludeClass = (ExcludeClassInterceptors)this.finder.getAnnotation(type, ExcludeClassInterceptors.class);
        ExcludeDefaultInterceptors excludeDefaults = (ExcludeDefaultInterceptors)this.finder.getAnnotation(type, ExcludeDefaultInterceptors.class);
        Method method = null;
        if (type instanceof Method) {
            method = (Method)type;
        }
        String ejbName = EjbNameThreadLocal.ejbName.get();
        InterceptorBindingMetaData interceptor = new InterceptorBindingMetaData();
        interceptor.setEjbName(ejbName);
        interceptor.setExcludeClassInterceptors(excludeClass != null);
        interceptor.setExcludeDefaultInterceptors(excludeDefaults != null);
        if (method != null) {
            NamedMethodMetaData namedMethod = new NamedMethodMetaData();
            namedMethod.setMethodName(method.getName());
            MethodParametersMetaData methodParams = EjbProcessorUtils.getMethodParameters(method);
            namedMethod.setMethodParams(methodParams);
            interceptor.setMethod(namedMethod);
        }
        InterceptorClassesMetaData classes = new InterceptorClassesMetaData();
        for (Class c : interceptors.value()) {
            classes.add(c.getName());
        }
        interceptor.setInterceptorClasses(classes);
        Descriptions descriptions = ProcessorUtils.getDescription((String)("@Interceptors for: " + type));
        interceptor.setDescriptions(descriptions);
        metaData.add(interceptor);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Interceptors.class);
    }
}

