/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.MethodParametersMetaDataParser;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;

public class MethodMetaDataParser
extends AbstractMetaDataParser<MethodMetaData> {
    public static final MethodMetaDataParser INSTANCE = new MethodMetaDataParser();

    @Override
    public MethodMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        MethodMetaData methodMetaData = new MethodMetaData();
        this.processElements(methodMetaData, reader);
        return methodMetaData;
    }

    @Override
    protected void processElement(MethodMetaData methodMetaData, XMLStreamReader reader) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case EJB_NAME: {
                String ejbName = MethodMetaDataParser.getElementText((XMLStreamReader)reader);
                methodMetaData.setEjbName(ejbName);
                return;
            }
            case METHOD_NAME: {
                String methodName = MethodMetaDataParser.getElementText((XMLStreamReader)reader);
                methodMetaData.setMethodName(methodName);
                return;
            }
            case METHOD_PARAMS: {
                MethodParametersMetaData methodParams = MethodParametersMetaDataParser.INSTANCE.parse(reader);
                methodMetaData.setMethodParams(methodParams);
                return;
            }
            case METHOD_INTF: {
                String methodIntfValue = MethodMetaDataParser.getElementText((XMLStreamReader)reader);
                if (methodIntfValue == null || methodIntfValue.isEmpty()) {
                    throw MethodMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected null or empty value for method-intf element"));
                }
                MethodInterfaceType methodIntf = MethodInterfaceType.valueOf(methodIntfValue);
                methodMetaData.setMethodIntf(methodIntf);
                return;
            }
        }
        throw MethodMetaDataParser.unexpectedElement((XMLStreamReader)reader);
    }
}

