/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.exchange.drools;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.component.rules.common.RulesActionType;
import org.switchyard.component.rules.common.RulesAuditType;
import org.switchyard.component.rules.config.model.RulesActionModel;
import org.switchyard.component.rules.config.model.RulesAuditModel;
import org.switchyard.component.rules.config.model.RulesComponentImplementationModel;
import org.switchyard.component.rules.exchange.BaseRulesExchangeHandler;
import org.switchyard.config.model.resource.ResourceModel;
import org.switchyard.metadata.ServiceOperation;

public class DroolsRulesExchangeHandler
extends BaseRulesExchangeHandler {
    private boolean _stateful;
    private String _messageContentName;
    private RulesAuditModel _rulesAudit;
    private Map<String, RulesActionModel> _actions = new HashMap<String, RulesActionModel>();
    private KnowledgeBase _kbase;
    private StatefulKnowledgeSession _ksession;
    private KnowledgeRuntimeLogger _klogger;

    @Override
    public void init(QName qname, RulesComponentImplementationModel model) {
        this._stateful = model.isStateful();
        this._messageContentName = model.getMessageContentName();
        if (this._messageContentName == null) {
            this._messageContentName = "messageContent";
        }
        this._rulesAudit = model.getRulesAudit();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (ResourceModel resource : model.getResources()) {
            this.addResource((org.switchyard.common.io.resource.Resource)resource, kbuilder);
        }
        this._kbase = kbuilder.newKnowledgeBase();
        for (RulesActionModel ram : model.getRulesActions()) {
            this._actions.put(ram.getName(), ram);
        }
    }

    private void addResource(org.switchyard.common.io.resource.Resource resource, KnowledgeBuilder kbuilder) {
        org.switchyard.common.io.resource.ResourceType resourceType;
        if (resource != null && (resourceType = resource.getType()) != null) {
            Resource kres = ResourceFactory.newUrlResource((URL)resource.getLocationURL());
            ResourceType kresType = ResourceType.getResourceType((String)resourceType.getName());
            kbuilder.add(kres, kresType);
        }
    }

    @Override
    public void start(ServiceReference serviceRef) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Exchange exchange) throws HandlerException {
        if (!ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            return;
        }
        Context context = exchange.getContext();
        ServiceOperation serviceOperation = exchange.getContract().getServiceOperation();
        RulesActionModel rulesActionModel = this._actions.get(serviceOperation.getName());
        RulesActionType rulesActionType = this.getRulesActionType(context, rulesActionModel);
        Message message = exchange.getMessage();
        Object content = message.getContent();
        switch (rulesActionType) {
            case EXECUTE_RULES: {
                StatelessKnowledgeSession ksession;
                if (this._stateful) {
                    if (!this.isContinue(context)) {
                        this.disposeStateful();
                    }
                    ksession = this.ensureStateful();
                    ksession.getGlobals().set("message", (Object)message);
                    ksession.insert(content);
                    ksession.fireAllRules();
                    message = (Message)ksession.getGlobals().get("message");
                    content = message.getContent();
                    if (!this.isDispose(context)) break;
                    this.disposeStateful();
                    break;
                }
                ksession = this._kbase.newStatelessKnowledgeSession();
                KnowledgeRuntimeLogger klogger = this.getLogger((KnowledgeRuntimeEventManager)ksession);
                try {
                    ksession.getGlobals().set("message", (Object)message);
                    ksession.execute(content);
                    message = (Message)ksession.getGlobals().get("message");
                    content = message.getContent();
                    if (klogger == null) break;
                }
                catch (Throwable throwable) {
                    if (klogger != null) {
                        klogger.close();
                    }
                    throw throwable;
                }
                klogger.close();
                break;
            }
        }
        ExchangePattern exchangePattern = serviceOperation.getExchangePattern();
        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
            message = exchange.createMessage();
            if (content != null) {
                message.setContent(content);
            }
            exchange.send(message);
        }
    }

    @Override
    public void stop(ServiceReference serviceRef) {
        this.disposeStateful();
    }

    @Override
    public void destroy(ServiceReference serviceRef) {
        this._kbase = null;
        this._actions.clear();
        this._rulesAudit = null;
        this._messageContentName = null;
        this._stateful = false;
    }

    private StatefulKnowledgeSession ensureStateful() {
        if (this._ksession == null) {
            this._ksession = this._kbase.newStatefulKnowledgeSession();
            this._klogger = this.getLogger((KnowledgeRuntimeEventManager)this._ksession);
        }
        return this._ksession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeStateful() {
        if (this._ksession != null) {
            try {
                this._ksession.halt();
            }
            finally {
                try {
                    this._ksession.dispose();
                }
                finally {
                    this._ksession = null;
                    try {
                        this._klogger.close();
                    }
                    finally {
                        this._klogger = null;
                    }
                }
            }
        }
    }

    private KnowledgeRuntimeLogger getLogger(KnowledgeRuntimeEventManager ksession) {
        if (this._rulesAudit != null) {
            String log;
            RulesAuditType type = this._rulesAudit.getType();
            if (type == null) {
                type = RulesAuditType.THREADED_FILE;
            }
            String fileName = (log = this._rulesAudit.getLog()) != null ? log : "event";
            Integer interval = this._rulesAudit.getInterval();
            if (interval == null) {
                interval = 1000;
            }
            switch (type) {
                case CONSOLE: {
                    return KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)ksession);
                }
                case FILE: {
                    return KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)ksession, (String)fileName);
                }
                case THREADED_FILE: {
                    return KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)ksession, (String)fileName, (int)interval);
                }
            }
        }
        return null;
    }
}

