/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.rules;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.component.rules.common.RulesActionType;
import org.switchyard.component.rules.config.model.v1.V1RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1RulesComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceInterfaceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1JavaComponentServiceInterfaceModel;
import org.switchyard.config.model.resource.v1.V1ResourceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;
import org.switchyard.tools.forge.plugin.TemplateResource;
import org.switchyard.tools.forge.rules.RulesFacet;

@Alias(value="rules-service")
@RequiresProject
@RequiresFacet(value={RulesFacet.class, ResourceFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands related to rules services in SwitchYard.")
public class RulesServicePlugin
implements Plugin {
    private static final String DEFAULT_RESOURCE_TYPE = "DRL";
    private static final String RULES_TEMPLATE = "RulesTemplate.drl";
    private static final String RULES_EXTENSION = ".drl";
    private static final String RULES_DIR = "META-INF";
    private static final String VAR_SERVICE_NAME = "${service.name}";
    private static final String VAR_PACKAGE_NAME = "${package.name}";
    @Inject
    private Project _project;
    @Inject
    private Shell _shell;

    @Command(value="create", help="Created a new service backed by a business rule.")
    public void newProcess(@Option(required=true, name="serviceName", description="The service name") String argServiceName, @Option(required=false, name="interfaceClass", description="The Java service interface") String argInterfaceClass, @Option(required=false, name="ruleDefinition", description="The business rule definition") String argRuleFilePath, @Option(required=false, name="ruleType", description="The type of rule definition (DRL, DSL, etc.") String argRuleDefinitionType, @Option(required=false, name="isStateful", description="Whether the rule session is stateful") Boolean argIsStateful, PipeOut out) throws IOException {
        String ruleDefinitionPath;
        String ruleDefinitionType;
        JavaSourceFacet java = (JavaSourceFacet)this._shell.getCurrentProject().getFacet(JavaSourceFacet.class);
        String pkgName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getTopLevelPackage();
        String interfaceClass = argInterfaceClass;
        if (interfaceClass == null) {
            if (pkgName == null) {
                pkgName = this._shell.promptCommon("Java package for service interface:", PromptType.JAVA_PACKAGE);
            }
            JavaInterface ruleInterface = (JavaInterface)((JavaInterface)((JavaInterface)((JavaInterface)JavaParser.create(JavaInterface.class)).setPackage(pkgName)).setName(argServiceName)).setPublic();
            java.saveJavaSource((JavaSource)ruleInterface);
            interfaceClass = ruleInterface.getQualifiedName();
            out.println("Created service interface [" + interfaceClass + "]");
        }
        if ((ruleDefinitionType = argRuleDefinitionType) == null) {
            ruleDefinitionType = DEFAULT_RESOURCE_TYPE;
        }
        if ((ruleDefinitionPath = argRuleFilePath) == null) {
            ruleDefinitionPath = RULES_DIR + File.separator + argServiceName + RULES_EXTENSION;
            TemplateResource template = new TemplateResource(RULES_TEMPLATE).replaceToken(VAR_SERVICE_NAME, argServiceName).replaceToken(VAR_PACKAGE_NAME, pkgName);
            template.writeTo(((ResourceFacet)this._project.getFacet(ResourceFacet.class)).getResource(ruleDefinitionPath));
            out.println("Created rule definition [" + ruleDefinitionPath + "]");
        }
        boolean isStateful = argIsStateful == null ? false : argIsStateful;
        this.createImplementationConfig(argServiceName, interfaceClass, ruleDefinitionPath, ruleDefinitionType, isStateful);
        out.println("Rule service " + argServiceName + " has been created.");
    }

    private void createImplementationConfig(String serviceName, String interfaceName, String rulesDefinition, String rulesDefinitionType, boolean isStateful) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        V1ComponentModel component = new V1ComponentModel();
        component.setName(serviceName);
        V1ComponentServiceModel service = new V1ComponentServiceModel();
        service.setName(serviceName);
        V1JavaComponentServiceInterfaceModel csi = new V1JavaComponentServiceInterfaceModel();
        csi.setInterface(interfaceName);
        service.setInterface((ComponentServiceInterfaceModel)csi);
        component.addService((ComponentServiceModel)service);
        V1RulesComponentImplementationModel rules = new V1RulesComponentImplementationModel();
        rules.addResource(new V1ResourceModel().setLocation(rulesDefinition).setType(ResourceType.valueOf((String)rulesDefinitionType)));
        rules.setStateful(isStateful);
        rules.addRulesAction(new V1RulesActionModel().setName("operation").setType(RulesActionType.EXECUTE_RULES));
        component.setImplementation((ComponentImplementationModel)rules);
        SwitchYardModel syConfig = switchYard.getSwitchYardConfig();
        syConfig.getComposite().addComponent((ComponentModel)component);
        switchYard.saveConfig();
    }
}

