/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.weld.injection.FieldInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

final class InjectableField {
    private final Field field;
    private final Bean<?> bean;
    private final FieldInjectionPoint injectionPoint;

    public InjectableField(final Field field, Bean<?> bean, FieldInjectionPoint injectionPoint) {
        this.bean = bean;
        this.field = field;
        this.injectionPoint = injectionPoint;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    public void inject(Object instance, BeanManagerImpl beanManager, CreationalContext<?> ctx) {
        try {
            Object value = beanManager.getReference((InjectionPoint)this.injectionPoint, this.bean, ctx);
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to perform CDI injection of field: " + this.field + " on " + instance.getClass(), e);
        }
    }
}

