/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.helpers.AbstractResourceServices;

public class WeldResourceInjectionServices
extends AbstractResourceServices
implements Service<WeldResourceInjectionServices>,
ResourceInjectionServices {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldResourceInjectionServices"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.weld");
    private static final String USER_TRANSACTION_LOCATION = "java:comp/UserTransaction";
    private static final String USER_TRANSACTION_CLASS_NAME = "javax.transaction.UserTransaction";
    private static final String HANDLE_DELEGATE_CLASS_NAME = "javax.ejb.spi.HandleDelegate";
    private static final String TIMER_SERVICE_CLASS_NAME = "javax.ejb.TimerService";
    private static final String ORB_CLASS_NAME = "org.omg.CORBA.ORB";
    private final Context context;

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public WeldResourceInjectionServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected static String getEJBResourceName(InjectionPoint injectionPoint, String proposedName) {
        if (injectionPoint.getType() instanceof Class) {
            Class type = (Class)injectionPoint.getType();
            if (USER_TRANSACTION_CLASS_NAME.equals(type.getName())) {
                return USER_TRANSACTION_LOCATION;
            }
            if (HANDLE_DELEGATE_CLASS_NAME.equals(type.getName())) {
                log.warn((Object)("Injection of @Resource HandleDelegate not supported in managed beans. Injection Point: " + injectionPoint));
                return proposedName;
            }
            if (ORB_CLASS_NAME.equals(type.getName())) {
                log.warn((Object)("Injection of @Resource ORB not supported in managed beans. Injection Point: " + injectionPoint));
                return proposedName;
            }
            if (TIMER_SERVICE_CLASS_NAME.equals(type.getName())) {
                log.warn((Object)("Injection of @Resource TimerService not supported in managed beans. Injection Point: " + injectionPoint));
                return proposedName;
            }
        }
        return proposedName;
    }

    public WeldResourceInjectionServices() {
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Context getContext() {
        return this.context;
    }

    protected String getResourceName(InjectionPoint injectionPoint) {
        return WeldResourceInjectionServices.getEJBResourceName(injectionPoint, super.getResourceName(injectionPoint));
    }

    public void cleanup() {
    }
}

