/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DataSourceAbstractImpl;
import org.jboss.logging.Messages;

public class DataSourceImpl
extends DataSourceAbstractImpl
implements DataSource {
    private static final long serialVersionUID = -5214100851560229431L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final boolean jta;
    private final String connectionUrl;
    private String driverClass;
    private final String driver;
    private final HashMap<String, String> connectionProperties;
    private final String newConnectionSql;
    private final CommonPool pool;

    public DataSourceImpl(String connectionUrl, String driverClass, String driver, TransactionIsolation transactionIsolation, Map<String, String> connectionProperties, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, String newConnectionSql, boolean useJavaContext, String poolName, boolean enabled, String jndiName, boolean spy, boolean useccm, boolean jta, CommonPool pool) throws ValidateException {
        super(transactionIsolation, timeOut, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useccm);
        this.jta = jta;
        this.connectionUrl = connectionUrl;
        this.driverClass = driverClass;
        this.driver = driver;
        if (connectionProperties != null) {
            this.connectionProperties = new HashMap(connectionProperties.size());
            this.connectionProperties.putAll(connectionProperties);
        } else {
            this.connectionProperties = new HashMap(0);
        }
        this.newConnectionSql = newConnectionSql;
        this.pool = pool;
        this.validate();
    }

    public boolean isJTA() {
        return this.jta;
    }

    public final String getConnectionUrl() {
        return this.connectionUrl;
    }

    public final String getDriverClass() {
        return this.driverClass;
    }

    public final String getDriver() {
        return this.driver;
    }

    public final Map<String, String> getConnectionProperties() {
        return Collections.unmodifiableMap(this.connectionProperties);
    }

    public final Statement getStatement() {
        return this.statement;
    }

    public final String getUrlDelimiter() {
        return this.urlDelimiter;
    }

    public final String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public final String getNewConnectionSql() {
        return this.newConnectionSql;
    }

    public final CommonPool getPool() {
        return this.pool;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.connectionProperties == null ? 0 : this.connectionProperties.hashCode());
        result = 31 * result + (this.connectionUrl == null ? 0 : this.connectionUrl.hashCode());
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.newConnectionSql == null ? 0 : this.newConnectionSql.hashCode());
        result = 31 * result + (this.pool == null ? 0 : this.pool.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataSourceImpl)) {
            return false;
        }
        DataSourceImpl other = (DataSourceImpl)obj;
        if (this.connectionProperties == null ? other.connectionProperties != null : !this.connectionProperties.equals(other.connectionProperties)) {
            return false;
        }
        if (this.connectionUrl == null ? other.connectionUrl != null : !this.connectionUrl.equals(other.connectionUrl)) {
            return false;
        }
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.driverClass == null ? other.driverClass != null : !this.driverClass.equals(other.driverClass)) {
            return false;
        }
        if (this.newConnectionSql == null ? other.newConnectionSql != null : !this.newConnectionSql.equals(other.newConnectionSql)) {
            return false;
        }
        return !(this.pool == null ? other.pool != null : !this.pool.equals(other.pool));
    }

    public String toString() {
        return "DataSourceImpl [connectionUrl=" + this.connectionUrl + ", driverClass=" + this.driverClass + ", driver=" + this.driver + ", connectionProperties=" + this.connectionProperties + ", newConnectionSql=" + this.newConnectionSql + ", pool=" + this.pool + "]";
    }

    public void validate() throws ValidateException {
        if (this.connectionUrl == null || this.connectionUrl.trim().length() == 0) {
            throw new ValidateException(bundle.requiredElementMissing(DataSource.Tag.CONNECTIONURL.getLocalName(), this.getClass().getCanonicalName()));
        }
        if (!(this.driverClass != null && this.driverClass.trim().length() != 0 || this.driver != null && this.driver.trim().length() != 0)) {
            throw new ValidateException(bundle.requiredElementMissing(DataSource.Tag.DRIVERCLASS.getLocalName(), this.getClass().getCanonicalName()));
        }
    }

    public final void forceDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }
}

