/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumerPollingStrategy;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDrivenPollingConsumer
extends PollingConsumerSupport
implements Processor {
    private static final transient Logger LOG = LoggerFactory.getLogger(EventDrivenPollingConsumer.class);
    private final BlockingQueue<Exchange> queue;
    private ExceptionHandler interruptedExceptionHandler = new LoggingExceptionHandler(EventDrivenPollingConsumer.class);
    private Consumer consumer;

    public EventDrivenPollingConsumer(Endpoint endpoint) {
        this(endpoint, new ArrayBlockingQueue<Exchange>(1000));
    }

    public EventDrivenPollingConsumer(Endpoint endpoint, BlockingQueue<Exchange> queue) {
        super(endpoint);
        this.queue = queue;
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange receive() {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(this + " is not started, but in state: " + this.getStatus().name());
        }
        while (this.isRunAllowed()) {
            try {
                this.beforePoll();
                Exchange exchange = this.queue.take();
                return exchange;
            }
            catch (InterruptedException e) {
                this.handleInterruptedException(e);
            }
            finally {
                this.afterPoll();
            }
        }
        LOG.trace("Consumer is not running, so returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange receive(long timeout) {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(this + " is not started, but in state: " + this.getStatus().name());
        }
        if (timeout == 0L && this.queue.isEmpty()) {
            return null;
        }
        try {
            this.beforePoll();
            Exchange exchange = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            return exchange;
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
            Exchange exchange = null;
            return exchange;
        }
        finally {
            this.afterPoll();
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.queue.offer(exchange);
    }

    public ExceptionHandler getInterruptedExceptionHandler() {
        return this.interruptedExceptionHandler;
    }

    public void setInterruptedExceptionHandler(ExceptionHandler interruptedExceptionHandler) {
        this.interruptedExceptionHandler = interruptedExceptionHandler;
    }

    protected void handleInterruptedException(InterruptedException e) {
        this.getInterruptedExceptionHandler().handleException(e);
    }

    protected void beforePoll() {
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            try {
                strategy.beforePoll();
            }
            catch (Exception e) {
                LOG.debug("Error occurred before polling " + this.consumer + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    protected void afterPoll() {
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            try {
                strategy.afterPoll();
            }
            catch (Exception e) {
                LOG.debug("Error occurred after polling " + this.consumer + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.consumer = this.getEndpoint().createConsumer(this);
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            strategy.onInit();
        } else {
            ServiceHelper.startService(this.consumer);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumer);
    }
}

