/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.MessageHelper;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed BrowsableEndpoint")
public class ManagedBrowsableEndpoint
extends ManagedEndpoint {
    private BrowsableEndpoint endpoint;

    public ManagedBrowsableEndpoint(BrowsableEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public BrowsableEndpoint getEndpoint() {
        return this.endpoint;
    }

    @ManagedOperation(description="Current number of Exchanges in Queue")
    public long queueSize() {
        return this.endpoint.getExchanges().size();
    }

    @ManagedOperation(description="Get Exchange from queue by index")
    public String browseExchange(Integer index) {
        if (index >= this.endpoint.getExchanges().size()) {
            return null;
        }
        Exchange exchange = this.endpoint.getExchanges().get(index);
        if (exchange == null) {
            return null;
        }
        return exchange.toString();
    }

    @ManagedOperation(description="Get message body from queue by index")
    public String browseMessageBody(Integer index) {
        if (index >= this.endpoint.getExchanges().size()) {
            return null;
        }
        Exchange exchange = this.endpoint.getExchanges().get(index);
        if (exchange == null) {
            return null;
        }
        Object body = exchange.hasOut() ? exchange.getOut().getBody() : exchange.getIn().getBody();
        return body != null ? body.toString() : null;
    }

    @ManagedOperation(description="Get message as XML from queue by index")
    public String browseMessageAsXml(Integer index) {
        if (index >= this.endpoint.getExchanges().size()) {
            return null;
        }
        Exchange exchange = this.endpoint.getExchanges().get(index);
        if (exchange == null) {
            return null;
        }
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        String xml = MessageHelper.dumpAsXml(msg);
        return xml;
    }
}

