/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.management.mbean.ManagedInstance;
import org.apache.camel.spi.ManagementStrategy;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed Service")
public class ManagedService
implements ManagedInstance {
    private final CamelContext context;
    private final Service service;
    private Route route;

    public ManagedService(CamelContext context, Service service) {
        this.context = context;
        this.service = service;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Service getService() {
        return this.service;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    @ManagedAttribute(description="Service State")
    public String getState() {
        if (this.service instanceof ServiceSupport) {
            ServiceStatus status = ((ServiceSupport)this.service).getStatus();
            if (status == null) {
                status = ServiceStatus.Stopped;
            }
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.context.getName();
    }

    @ManagedAttribute(description="Route id")
    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    @ManagedOperation(description="Start Service")
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.service.start();
    }

    @ManagedOperation(description="Stop Service")
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.service.stop();
    }

    @ManagedAttribute(description="Whether this service supports suspension")
    public boolean isSupportSuspension() {
        return this.service instanceof SuspendableService;
    }

    @ManagedAttribute(description="Whether this service is suspended")
    public boolean isSuspended() {
        if (this.service instanceof SuspendableService) {
            SuspendableService ss = (SuspendableService)this.service;
            return ss.isSuspended();
        }
        return false;
    }

    @ManagedOperation(description="Suspend Service")
    public void suspend() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        if (!(this.service instanceof SuspendableService)) {
            throw new UnsupportedOperationException("suspend() is not a supported operation");
        }
        SuspendableService ss = (SuspendableService)this.service;
        ss.suspend();
    }

    @ManagedOperation(description="Resume Service")
    public void resume() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        if (!(this.service instanceof SuspendableService)) {
            throw new UnsupportedOperationException("resume() is not a supported operation");
        }
        SuspendableService ss = (SuspendableService)this.service;
        ss.resume();
    }

    @Override
    public Object getInstance() {
        return this.service;
    }
}

