/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.Service;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class LRUCache<K, V>
extends LinkedHashMap<K, V>
implements Service {
    private static final long serialVersionUID = -342098639681884414L;
    private int maxCacheSize = 10000;
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();

    public LRUCache(int maximumCacheSize) {
        this(maximumCacheSize, maximumCacheSize, 0.75f, true);
    }

    public LRUCache(int initialCapacity, int maximumCacheSize, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxCacheSize = maximumCacheSize;
    }

    @Override
    public V get(Object o) {
        Object answer = super.get(o);
        if (answer != null) {
            this.hits.incrementAndGet();
        } else {
            this.misses.incrementAndGet();
        }
        return answer;
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getMisses() {
        return this.misses.get();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void resetStatistics() {
        this.hits.set(0L);
        this.misses.set(0L);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.maxCacheSize;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        if (!this.isEmpty()) {
            ServiceHelper.stopServices(this.values());
            this.clear();
            this.hits.set(0L);
            this.misses.set(0L);
        }
    }

    @Override
    public String toString() {
        return "LRUCache@" + ObjectHelper.getIdentityHashCode(this);
    }
}

