/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.internal;

import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.bean.deploy.BeanComponentActivator;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.CDIBean;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.TransformerTypes;
import org.switchyard.transform.TransformerUtil;

public class SimpleCDIDeployment
extends AbstractDeployment {
    public SimpleCDIDeployment() {
        super(null);
    }

    protected void doInit() {
    }

    protected void doStart() {
        BeanDeploymentMetaData beanDeploymentMetaData = BeanDeploymentMetaData.lookupBeanDeploymentMetaData();
        this.deployTransformers(beanDeploymentMetaData, this.getDomain());
        this.deployServicesAndProxies(beanDeploymentMetaData, this.getDomain());
    }

    protected void doStop() {
        this.undeployAutoRegisteredTransformers();
    }

    protected void doDestroy() {
    }

    private void deployTransformers(BeanDeploymentMetaData beanDeploymentMetaData, ServiceDomain domain) {
        TransformerRegistry transformerRegistry = domain.getTransformerRegistry();
        for (CDIBean deploymentBean : beanDeploymentMetaData.getDeploymentBeans()) {
            Class beanClass = deploymentBean.getBean().getBeanClass();
            if (!TransformerUtil.isTransformer((Class)beanClass)) continue;
            List transformers = TransformerUtil.listTransformations((Class)beanClass);
            for (TransformerTypes transformer : transformers) {
                transformerRegistry.addTransformer(TransformerUtil.newTransformer((Class)beanClass, (QName)transformer.getFrom(), (QName)transformer.getTo()));
            }
        }
    }

    private void deployServicesAndProxies(BeanDeploymentMetaData beanDeploymentMetaData, ServiceDomain domain) {
        if (beanDeploymentMetaData == null) {
            throw new SwitchYardException("Failed to lookup BeanDeploymentMetaData from Naming Context.");
        }
        BeanComponentActivator activator = new BeanComponentActivator();
        for (ServiceDescriptor serviceDescriptor : beanDeploymentMetaData.getServiceDescriptors()) {
            String serviceName = serviceDescriptor.getServiceName();
            ExchangeHandler handler = serviceDescriptor.getHandler();
            activator.lookupBeanMetaData();
            ServiceInterface serviceInterface = activator.buildServiceInterface(serviceName);
            QName serviceQName = XMLHelper.createQName((String)domain.getName().getNamespaceURI(), (String)serviceName);
            ServiceReference service = domain.registerService(serviceQName, handler, serviceInterface);
            activator.start(service);
            this.deployAutoRegisteredTransformers(serviceInterface);
        }
    }
}

