/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.bean;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.bean.Service;
import org.switchyard.tools.forge.bean.BeanFacet;

@Alias(value="bean-service")
@RequiresProject
@RequiresFacet(value={BeanFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to create, edit, and remove CDI-based services in SwitchYard.")
public class BeanServicePlugin
implements Plugin {
    @Inject
    private Project _project;
    @Inject
    private Shell _shell;

    @Command(value="create", help="Created a new service backed by a CDI bean.")
    public void newBean(@Option(required=true, name="serviceName", description="The service name") String serviceName, PipeOut out) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)this._shell.getCurrentProject().getFacet(JavaSourceFacet.class);
        String pkgName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getTopLevelPackage();
        if (pkgName == null) {
            pkgName = this._shell.promptCommon("Java package for service interface and implementation:", PromptType.JAVA_PACKAGE);
        }
        JavaInterface beanInterface = (JavaInterface)((JavaInterface)((JavaInterface)((JavaInterface)JavaParser.create(JavaInterface.class)).setPackage(pkgName)).setName(serviceName)).setPublic();
        java.saveJavaSource((JavaSource)beanInterface);
        JavaClass beanClass = (JavaClass)((JavaClass)((JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setPackage(pkgName)).setName(serviceName + "Bean")).addInterface(beanInterface)).setPublic();
        Annotation serviceAnnotation = beanClass.addAnnotation(Service.class);
        serviceAnnotation.setLiteralValue(beanInterface.getName() + ".class");
        java.saveJavaSource((JavaSource)beanClass);
        out.println("Created service interface [" + beanInterface.getName() + "]");
        out.println("Created service implementation [" + beanClass.getName() + "]");
        out.println(out.renderColor(ShellColor.BLUE, "NOTE: Run 'mvn package' to make " + serviceName + " visible to SwitchYard shell."));
    }
}

