/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.v1;

import java.net.URI;
import java.net.URISyntaxException;
import org.switchyard.component.camel.config.model.CamelBindingModel;
import org.switchyard.component.camel.config.model.v1.V1BaseCamelBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V1CamelBindingModel
extends V1BaseCamelBindingModel {
    public static final String CAMEL = "camel";
    public static final String CONFIG_URI = "configURI";
    private URI _configURI;

    public V1CamelBindingModel() {
        super(CAMEL);
    }

    public V1CamelBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder(new String[0]);
    }

    public URI getConfigURI() {
        if (this._configURI == null) {
            this._configURI = this.parseStringAsURI(this.getModelAttribute(CONFIG_URI));
        }
        return this._configURI;
    }

    public CamelBindingModel setConfigURI(URI uri) {
        if (this._configURI == null) {
            this.setModelAttribute(CONFIG_URI, uri.toString());
            this._configURI = uri;
        }
        return this;
    }

    @Override
    public URI getComponentURI() {
        return this.getConfigURI();
    }

    private URI parseStringAsURI(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI [" + uriString + "] was invalid. Please check the configuration.", e);
        }
    }
}

