/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.txn.TransactionSynchronizationRegistryService;
import org.jboss.as.txn.UserTransactionService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class TransactionJndiBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
            this.bindServices(deploymentUnit, serviceTarget, moduleDescription, moduleDescription.getModuleName(), moduleContextServiceName);
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindServices(deploymentUnit, serviceTarget, moduleDescription, component.getComponentName(), compContextServiceName);
        }
    }

    private void bindServices(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, EEModuleDescription description, String componentName, ServiceName contextServiceName) {
        ServiceName userTransactionServiceName = contextServiceName.append(new String[]{"UserTransaction"});
        BinderService userTransactionBindingService = new BinderService("UserTransaction");
        serviceTarget.addService(userTransactionServiceName, (Service)userTransactionBindingService).addDependency(UserTransactionService.SERVICE_NAME, UserTransaction.class, (Injector)new ManagedReferenceInjector(userTransactionBindingService.getManagedObjectInjector())).addDependency(contextServiceName, NamingStore.class, userTransactionBindingService.getNamingStoreInjector()).install();
        ServiceName transactionSynchronizationRegistryName = contextServiceName.append(new String[]{"TransactionSynchronizationRegistry"});
        BinderService transactionSyncBinderService = new BinderService("TransactionSynchronizationRegistry");
        serviceTarget.addService(transactionSynchronizationRegistryName, (Service)transactionSyncBinderService).addDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, TransactionSynchronizationRegistry.class, (Injector)new ManagedReferenceInjector(transactionSyncBinderService.getManagedObjectInjector())).addDependency(contextServiceName, NamingStore.class, transactionSyncBinderService.getNamingStoreInjector()).install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

