/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.pull;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.type.Classes;

public abstract class Puller<R> {
    public R pull(String resource) throws IOException {
        return this.pull(resource, this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(String resource, Class<?> caller) throws IOException {
        InputStream is = Classes.getResourceAsStream(resource, caller);
        if (is != null) {
            try {
                R r = this.pull(is);
                return r;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(String resource, ClassLoader loader) throws IOException {
        InputStream is = Classes.getResourceAsStream(resource, loader);
        if (is != null) {
            try {
                R r = this.pull(is);
                return r;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    public R pull(URI uri) throws IOException {
        return this.pull(uri.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            R r = this.pull(is);
            return r;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public R pull(Resource resource) throws IOException {
        return this.pull(resource.getLocationURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            R r = this.pull(is);
            return r;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public abstract R pull(InputStream var1) throws IOException;
}

