/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.type.Classes;

public abstract class BaseResource
implements Resource {
    @Override
    public URL getLocationURL() {
        return BaseResource.getURL(this.getLocation(), this.getClass());
    }

    public static URL getURL(String location) {
        return BaseResource.getURL(location, BaseResource.class);
    }

    public static URL getURL(String location, Class<?> caller) {
        if (location != null) {
            try {
                if (location.startsWith("http:") || location.startsWith("https:")) {
                    return new URL(location);
                }
                if (location.startsWith("file:")) {
                    return new File(location.substring(5)).toURI().toURL();
                }
                return Classes.getResource(location, caller);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }
}

