/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.resource;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;

public final class ResourceType {
    private static final Logger LOGGER;
    private static final Map<String, ResourceType> TYPES;
    private final String _name;
    private String _description;
    private final Set<String> _extensions;

    private ResourceType(String name, String description, Set<String> extensions) {
        this._name = name;
        this._description = description;
        this._extensions = extensions;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public Set<String> getExtensions() {
        return Collections.unmodifiableSet(this._extensions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return !(this._name == null ? other._name != null : !this._name.equals(other._name));
    }

    public static synchronized ResourceType install(String name) {
        return ResourceType.install(name, null, new String[0]);
    }

    public static synchronized ResourceType install(String name, String description, String ... extensions) {
        LinkedHashSet<String> ext_set = null;
        if (extensions != null) {
            for (String ext : extensions) {
                if ((ext = Strings.trimToNull(ext)) == null) continue;
                if (ext_set == null) {
                    ext_set = new LinkedHashSet<String>();
                }
                ext_set.add(ext);
            }
        }
        return ResourceType.install(name, description, ext_set);
    }

    public static synchronized ResourceType install(String name, String description, Set<String> extensions) {
        ResourceType type;
        if ((name = Strings.trimToNull(name)) == null) {
            throw new IllegalArgumentException("name");
        }
        name = name.toUpperCase();
        description = Strings.trimToNull(description);
        LinkedHashSet<String> ext_set = new LinkedHashSet<String>();
        if (extensions != null) {
            for (String ext : extensions) {
                if ((ext = Strings.trimToNull(ext)) == null) continue;
                ext_set.add(ext.toLowerCase());
            }
        }
        if ((type = TYPES.get(name)) == null) {
            type = new ResourceType(name, description, ext_set);
            TYPES.put(name, type);
        } else {
            if (type._description == null && description != null) {
                type._description = description;
            }
            for (String ext : ext_set) {
                if (type._extensions.contains(ext)) continue;
                type._extensions.add(ext);
            }
        }
        return type;
    }

    public static ResourceType valueOf(String name) {
        return name != null ? TYPES.get(name.trim().toUpperCase()) : null;
    }

    static {
        List<URL> urls;
        LOGGER = Logger.getLogger(ResourceType.class);
        TYPES = new ConcurrentHashMap<String, ResourceType>();
        try {
            urls = Classes.getResources("/org/switchyard/common/io/resource/resourceType.properties", ResourceType.class);
        }
        catch (Throwable t) {
            LOGGER.fatal((Object)t.getMessage());
            urls = Collections.emptyList();
        }
        PropertiesPuller props_puller = new PropertiesPuller();
        for (URL url : urls) {
            try {
                Properties props = (Properties)props_puller.pull(url);
                for (Object key : props.keySet()) {
                    String name = (String)key;
                    StringTokenizer st = new StringTokenizer(props.getProperty(name), "|");
                    String description = st.hasMoreTokens() ? Strings.trimToNull(st.nextToken()) : null;
                    Set<String> extensions = st.hasMoreTokens() ? Strings.uniqueSplitTrimToNull(st.nextToken(), ",") : null;
                    ResourceType.install(name, description, extensions);
                }
            }
            catch (Throwable t) {
                LOGGER.error((Object)t.getMessage());
            }
        }
    }
}

