/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.logging.Logger;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicUserCredentialsDeployer
extends XmlDeployer {
    private static final Logger log = Logger.getLogger(BasicUserCredentialsDeployer.class);
    private final HornetQSecurityManager hornetQSecurityManager;
    private static final String PASSWORD_ATTRIBUTE = "password";
    private static final String ROLES_NODE = "role";
    private static final String ROLE_ATTR_NAME = "name";
    private static final String DEFAULT_USER = "defaultuser";
    private static final String USER = "user";

    public BasicUserCredentialsDeployer(DeploymentManager deploymentManager, HornetQSecurityManager hornetQSecurityManager) {
        super(deploymentManager);
        this.hornetQSecurityManager = hornetQSecurityManager;
    }

    @Override
    public String[] getElementTagName() {
        return new String[]{DEFAULT_USER, USER};
    }

    @Override
    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate(rootNode, "schema/hornetq-users.xsd");
    }

    @Override
    public void deploy(Node node) throws Exception {
        String username = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
        String password = node.getAttributes().getNamedItem(PASSWORD_ATTRIBUTE).getNodeValue();
        this.hornetQSecurityManager.addUser(username, password);
        String nodeName = node.getNodeName();
        if (DEFAULT_USER.equalsIgnoreCase(nodeName)) {
            this.hornetQSecurityManager.setDefaultUser(username);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!ROLES_NODE.equalsIgnoreCase(child.getNodeName())) continue;
            String role = child.getAttributes().getNamedItem(ROLE_ATTR_NAME).getNodeValue();
            this.hornetQSecurityManager.addRole(username, role);
        }
    }

    @Override
    public void undeploy(Node node) throws Exception {
        String username = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
        this.hornetQSecurityManager.removeUser(username);
    }

    @Override
    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-users.xml"};
    }
}

