/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.cursor.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.cursor.PageCache;
import org.hornetq.core.paging.cursor.PageCursorProvider;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.PageSubscriptionCounter;
import org.hornetq.core.paging.cursor.PagedReference;
import org.hornetq.core.paging.cursor.impl.PagePositionImpl;
import org.hornetq.core.paging.cursor.impl.PageSubscriptionCounterImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperationAbstract;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.Future;
import org.hornetq.utils.LinkedListIterator;

public class PageSubscriptionImpl
implements PageSubscription {
    private static final Logger log = Logger.getLogger(PageSubscriptionImpl.class);
    private final boolean isTrace = log.isTraceEnabled();
    private volatile boolean autoCleanup = true;
    private final StorageManager store;
    private final long cursorId;
    private Queue queue;
    private final boolean persistent;
    private final Filter filter;
    private final PagingStore pageStore;
    private final PageCursorProvider cursorProvider;
    private volatile PagePosition lastAckedPosition;
    private List<PagePosition> recoveredACK;
    private final SortedMap<Long, PageCursorInfo> consumedPages = Collections.synchronizedSortedMap(new TreeMap());
    private final PageSubscriptionCounter counter;
    private final Executor executor;
    private final AtomicLong deliveredCount = new AtomicLong(0L);
    private final ConcurrentLinkedQueue<PagePosition> redeliveries = new ConcurrentLinkedQueue();

    private static void trace(String message) {
        log.trace(message);
    }

    public PageSubscriptionImpl(PageCursorProvider cursorProvider, PagingStore pageStore, StorageManager store, Executor executor, Filter filter, long cursorId, boolean persistent) {
        this.pageStore = pageStore;
        this.store = store;
        this.cursorProvider = cursorProvider;
        this.cursorId = cursorId;
        this.executor = executor;
        this.filter = filter;
        this.persistent = persistent;
        this.counter = new PageSubscriptionCounterImpl(store, this, executor, persistent, cursorId);
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pageStore;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public boolean isPaging() {
        return this.pageStore.isPaging();
    }

    @Override
    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    @Override
    public void disableAutoCleanup() {
        this.autoCleanup = false;
    }

    @Override
    public void enableAutoCleanup() {
        this.autoCleanup = true;
    }

    public PageCursorProvider getProvider() {
        return this.cursorProvider;
    }

    @Override
    public void bookmark(PagePosition position) throws Exception {
        PageCursorInfo cursorInfo = this.getPageInfo(position);
        if (position.getMessageNr() > 0) {
            cursorInfo.confirmed.addAndGet(position.getMessageNr());
        }
        this.confirmPosition(position);
    }

    @Override
    public long getMessageCount() {
        return this.counter.getValue() - this.deliveredCount.get();
    }

    @Override
    public PageSubscriptionCounter getCounter() {
        return this.counter;
    }

    @Override
    public void scheduleCleanupCheck() {
        if (this.autoCleanup) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        PageSubscriptionImpl.this.cleanupEntries();
                    }
                    catch (Exception e) {
                        log.warn("Error on cleaning up cursor pages", e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupEntries() throws Exception {
        TransactionImpl tx = new TransactionImpl(this.store);
        boolean persist = false;
        final ArrayList<PageCursorInfo> completedPages = new ArrayList<PageCursorInfo>();
        PageSubscriptionImpl pageSubscriptionImpl = this;
        synchronized (pageSubscriptionImpl) {
            for (Map.Entry<Long, PageCursorInfo> entry : this.consumedPages.entrySet()) {
                PageCursorInfo info = entry.getValue();
                if (!info.isDone() || info.isPendingDelete() || this.lastAckedPosition == null) continue;
                if (entry.getKey().longValue() == this.lastAckedPosition.getPageNr()) {
                    PageSubscriptionImpl.trace("We can't clear page " + entry.getKey() + " now since it's the current page");
                    continue;
                }
                info.setPendingDelete();
                completedPages.add(entry.getValue());
            }
        }
        for (int i = 0; i < completedPages.size(); ++i) {
            PageCursorInfo info = (PageCursorInfo)completedPages.get(i);
            for (PagePosition pos : info.acks) {
                if (pos.getRecordID() <= 0L) continue;
                this.store.deleteCursorAcknowledgeTransactional(tx.getID(), pos.getRecordID());
                if (persist) continue;
                tx.setContainsPersistent();
                persist = true;
            }
        }
        tx.addOperation(new TransactionOperationAbstract(){

            @Override
            public void afterCommit(Transaction tx) {
                PageSubscriptionImpl.this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        PageSubscriptionImpl pageSubscriptionImpl = PageSubscriptionImpl.this;
                        synchronized (pageSubscriptionImpl) {
                            for (PageCursorInfo completePage : completedPages) {
                                if (PageSubscriptionImpl.this.isTrace) {
                                    PageSubscriptionImpl.trace("Removing page " + completePage.getPageId());
                                }
                                if (PageSubscriptionImpl.this.consumedPages.remove(completePage.getPageId()) != null) continue;
                                log.warn("Couldn't remove page " + completePage.getPageId() + " from consumed pages on cursor for address " + PageSubscriptionImpl.this.pageStore.getAddress());
                            }
                        }
                        PageSubscriptionImpl.this.cursorProvider.scheduleCleanup();
                    }
                });
            }
        });
        tx.commit();
    }

    public String toString() {
        return "PageSubscriptionImpl [cursorId=" + this.cursorId + ", queue=" + this.queue + "]";
    }

    private PagedReference getReference(PagePosition pos) throws Exception {
        return this.cursorProvider.newReference(pos, this.cursorProvider.getMessage(pos), this);
    }

    @Override
    public LinkedListIterator<PagedReference> iterator() {
        return new CursorIterator();
    }

    private PagedReference internalGetNext(PagePosition pos) {
        PagedMessage serverMessage;
        PagePosition retPos = pos.nextMessage();
        PageCache cache = this.cursorProvider.getPageCache(pos);
        if (cache == null || !cache.isLive() && retPos.getMessageNr() >= cache.getNumberOfMessages()) {
            retPos = pos.nextPage();
            cache = this.cursorProvider.getPageCache(retPos);
            if (cache == null) {
                return null;
            }
            if (retPos.getMessageNr() >= cache.getNumberOfMessages()) {
                return null;
            }
        }
        if ((serverMessage = cache.getMessage(retPos.getMessageNr())) != null) {
            return this.cursorProvider.newReference(retPos, serverMessage, this);
        }
        return null;
    }

    private boolean routed(PagedMessage message) {
        long id = this.getId();
        for (long qid : message.getQueueIDs()) {
            if (qid != id) continue;
            return true;
        }
        return false;
    }

    private synchronized PagePosition getStartPosition() {
        for (Map.Entry<Long, PageCursorInfo> entry : this.consumedPages.entrySet()) {
            if (entry.getValue().isPendingDelete()) continue;
            if (entry.getValue().acks.isEmpty()) {
                return new PagePositionImpl(entry.getKey(), -1);
            }
            PagePosition retValue = null;
            for (PagePosition pos : entry.getValue().acks) {
                if (this.isTrace) {
                    PageSubscriptionImpl.trace("Analizing " + pos);
                }
                if (retValue != null && retValue.getMessageNr() <= pos.getMessageNr()) continue;
                retValue = pos;
            }
            if (this.isTrace) {
                PageSubscriptionImpl.trace("Returning initial position " + retValue);
            }
            return retValue;
        }
        return new PagePositionImpl(this.pageStore.getFirstPage(), -1);
    }

    @Override
    public void confirmPosition(Transaction tx, PagePosition position) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledgeTransactional(tx.getID(), this.cursorId, position);
        }
        this.installTXCallback(tx, position);
    }

    @Override
    public void ackTx(Transaction tx, PagedReference reference) throws Exception {
        this.confirmPosition(tx, reference.getPosition());
        this.counter.increment(tx, -1);
        PageTransactionInfo txInfo = this.getPageTransaction(reference);
        if (txInfo != null) {
            txInfo.storeUpdate(this.store, this.pageStore.getPagingManager(), tx);
        }
    }

    @Override
    public void ack(PagedReference reference) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.store);
        this.ackTx(tx, reference);
        tx.commit();
    }

    @Override
    public void confirmPosition(final PagePosition position) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledge(this.cursorId, position);
        }
        this.store.afterCompleteOperations(new IOAsyncTask(){

            @Override
            public void onError(int errorCode, String errorMessage) {
            }

            @Override
            public void done() {
                PageSubscriptionImpl.this.processACK(position);
            }
        });
    }

    @Override
    public long getFirstPage() {
        if (this.consumedPages.isEmpty()) {
            return 0L;
        }
        return this.consumedPages.firstKey();
    }

    @Override
    public void addPendingDelivery(PagePosition position) {
        this.getPageInfo(position).incrementPendingTX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redeliver(PagePosition position) {
        ConcurrentLinkedQueue<PagePosition> concurrentLinkedQueue = this.redeliveries;
        synchronized (concurrentLinkedQueue) {
            this.redeliveries.add(position);
            PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(position.getPageNr());
            if (pageInfo != null) {
                pageInfo.decrementPendingTX();
            }
        }
    }

    @Override
    public PagedMessage queryMessage(PagePosition pos) {
        try {
            return this.cursorProvider.getMessage(pos);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void reloadACK(PagePosition position) {
        if (this.recoveredACK == null) {
            this.recoveredACK = new LinkedList<PagePosition>();
        }
        this.recoveredACK.add(position);
    }

    @Override
    public void reloadPreparedACK(Transaction tx, PagePosition position) {
        this.deliveredCount.incrementAndGet();
        this.installTXCallback(tx, position);
    }

    @Override
    public void positionIgnored(PagePosition position) {
        this.processACK(position);
    }

    @Override
    public void lateDeliveryRollback(PagePosition position) {
        PageCursorInfo cursorInfo = this.processACK(position);
        cursorInfo.decrementPendingTX();
    }

    @Override
    public boolean isComplete(long page) {
        PageCursorInfo info = (PageCursorInfo)this.consumedPages.get(page);
        return info != null && info.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        long tx = this.store.generateUniqueID();
        try {
            boolean isPersistent = false;
            PageSubscriptionImpl pageSubscriptionImpl = this;
            synchronized (pageSubscriptionImpl) {
                for (PageCursorInfo cursor : this.consumedPages.values()) {
                    for (PagePosition info : cursor.acks) {
                        if (info.getRecordID() == 0L) continue;
                        isPersistent = true;
                        this.store.deleteCursorAcknowledgeTransactional(tx, info.getRecordID());
                    }
                }
            }
            if (isPersistent) {
                this.store.commit(tx);
            }
            this.cursorProvider.close(this);
        }
        catch (Exception e) {
            try {
                this.store.rollback(tx);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    @Override
    public long getId() {
        return this.cursorId;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void processReload() throws Exception {
        if (this.recoveredACK != null) {
            if (this.isTrace) {
                PageSubscriptionImpl.trace("********** processing reload!!!!!!!");
            }
            Collections.sort(this.recoveredACK);
            boolean first = true;
            Iterator<PagePosition> i$ = this.recoveredACK.iterator();
            while (i$.hasNext()) {
                PagePosition pos;
                this.lastAckedPosition = pos = i$.next();
                PageCursorInfo positions = this.getPageInfo(pos);
                if (first) {
                    first = false;
                    if (pos.getMessageNr() > 0) {
                        positions.confirmed.addAndGet(pos.getMessageNr());
                    }
                }
                positions.addACK(pos);
            }
            this.recoveredACK.clear();
            this.recoveredACK = null;
        }
    }

    @Override
    public void flushExecutors() {
        Future future = new Future();
        this.executor.execute(future);
        while (!future.await(1000L)) {
            log.warn("Waiting page cursor to finish executors - " + this);
        }
    }

    @Override
    public void stop() {
        this.flushExecutors();
    }

    @Override
    public void printDebug() {
        this.printDebug(this.toString());
    }

    public void printDebug(String msg) {
        System.out.println("Debug information on PageCurorImpl- " + msg);
        for (PageCursorInfo info : this.consumedPages.values()) {
            System.out.println(info);
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    private synchronized PageCursorInfo getPageInfo(PagePosition pos) {
        return this.getPageInfo(pos, true);
    }

    private synchronized PageCursorInfo getPageInfo(PagePosition pos, boolean create) {
        PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(pos.getPageNr());
        if (create && pageInfo == null) {
            PageCache cache = this.cursorProvider.getPageCache(pos);
            pageInfo = new PageCursorInfo(pos.getPageNr(), cache.getNumberOfMessages(), cache);
            this.consumedPages.put(pos.getPageNr(), pageInfo);
        }
        return pageInfo;
    }

    protected boolean match(ServerMessage message) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.match(message);
    }

    private PageCursorInfo processACK(PagePosition pos) {
        if (this.lastAckedPosition == null || pos.compareTo(this.lastAckedPosition) > 0) {
            if (this.isTrace) {
                log.trace("a new position is being processed as ACK");
            }
            if (this.lastAckedPosition != null && this.lastAckedPosition.getPageNr() != pos.getPageNr()) {
                if (this.isTrace) {
                    log.trace("Scheduling cleanup on pageSubscription for address = " + this.pageStore.getAddress() + " queue = " + this.getQueue().getName());
                }
                if (this.autoCleanup) {
                    this.scheduleCleanupCheck();
                }
            }
            this.lastAckedPosition = pos;
        }
        PageCursorInfo info = this.getPageInfo(pos);
        info.addACK(pos);
        return info;
    }

    private void installTXCallback(Transaction tx, PagePosition position) {
        if (position.getRecordID() > 0L) {
            tx.setContainsPersistent();
        }
        this.getPageInfo(position).remove(position);
        PageCursorTX cursorTX = (PageCursorTX)tx.getProperty(8);
        if (cursorTX == null) {
            cursorTX = new PageCursorTX();
            tx.putProperty(8, cursorTX);
            tx.addOperation(cursorTX);
        }
        cursorTX.addPositionConfirmation(this, position);
    }

    private PageTransactionInfo getPageTransaction(PagedReference reference) {
        if (reference.getPagedMessage().getTransactionID() >= 0L) {
            return this.pageStore.getPagingManager().getTransaction(reference.getPagedMessage().getTransactionID());
        }
        return null;
    }

    private void onPageDone(PageCursorInfo info) {
        if (this.autoCleanup) {
            this.scheduleCleanupCheck();
        }
    }

    class CursorIterator
    implements LinkedListIterator<PagedReference> {
        private PagePosition position = null;
        private PagePosition lastOperation = null;
        private volatile boolean isredelivery = false;
        private volatile PagedReference lastRedelivery = null;
        private volatile PagedReference cachedNext;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void repeat() {
            if (this.isredelivery) {
                ConcurrentLinkedQueue concurrentLinkedQueue = PageSubscriptionImpl.this.redeliveries;
                synchronized (concurrentLinkedQueue) {
                    this.cachedNext = this.lastRedelivery;
                }
            } else {
                this.position = this.lastOperation == null ? null : this.lastOperation;
            }
        }

        @Override
        public synchronized PagedReference next() {
            if (this.cachedNext != null) {
                PagedReference retPos = this.cachedNext;
                this.cachedNext = null;
                return retPos;
            }
            try {
                if (this.position == null) {
                    this.position = PageSubscriptionImpl.this.getStartPosition();
                }
                return this.moveNext();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PagedReference moveNext() throws Exception {
            PageSubscriptionImpl pageSubscriptionImpl = PageSubscriptionImpl.this;
            synchronized (pageSubscriptionImpl) {
                boolean match = false;
                PagedReference message = null;
                PagePosition lastPosition = this.position;
                PagePosition tmpPosition = this.position;
                do {
                    PageCursorInfo info;
                    ConcurrentLinkedQueue concurrentLinkedQueue = PageSubscriptionImpl.this.redeliveries;
                    synchronized (concurrentLinkedQueue) {
                        PagePosition redelivery = (PagePosition)PageSubscriptionImpl.this.redeliveries.poll();
                        if (redelivery != null) {
                            PagedReference redeliveredMsg;
                            this.isredelivery = true;
                            this.lastRedelivery = redeliveredMsg = PageSubscriptionImpl.this.getReference(redelivery);
                            return redeliveredMsg;
                        }
                        this.lastRedelivery = null;
                        this.isredelivery = false;
                        message = PageSubscriptionImpl.this.internalGetNext(tmpPosition);
                    }
                    if (message == null) break;
                    tmpPosition = message.getPosition();
                    boolean valid = true;
                    boolean ignored = false;
                    valid = PageSubscriptionImpl.this.routed(message.getPagedMessage());
                    if (!valid) {
                        ignored = true;
                    }
                    if ((info = PageSubscriptionImpl.this.getPageInfo(message.getPosition(), false)) != null && info.isRemoved(message.getPosition())) continue;
                    if (valid && message.getPagedMessage().getTransactionID() >= 0L) {
                        PageTransactionInfo tx = PageSubscriptionImpl.this.pageStore.getPagingManager().getTransaction(message.getPagedMessage().getTransactionID());
                        if (tx == null) {
                            log.warn("Couldn't locate page transaction " + message.getPagedMessage().getTransactionID() + ", ignoring message on position " + message.getPosition() + " on address=" + PageSubscriptionImpl.this.pageStore.getAddress() + " queue=" + PageSubscriptionImpl.this.queue.getName());
                            valid = false;
                            ignored = true;
                        } else if (tx.deliverAfterCommit(PageSubscriptionImpl.this, message.getPosition())) {
                            valid = false;
                            ignored = false;
                        }
                    }
                    if (valid && info != null && info.isRemoved(message.getPosition())) {
                        valid = false;
                    }
                    if (!ignored) {
                        this.position = message.getPosition();
                    }
                    if (valid) {
                        match = PageSubscriptionImpl.this.match(message.getMessage());
                        if (match) continue;
                        PageSubscriptionImpl.this.processACK(message.getPosition());
                        continue;
                    }
                    if (!ignored) continue;
                    PageSubscriptionImpl.this.positionIgnored(message.getPosition());
                } while (message != null && !match);
                if (message != null) {
                    this.lastOperation = lastPosition;
                }
                return message;
            }
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.cachedNext != null) {
                return true;
            }
            if (!PageSubscriptionImpl.this.pageStore.isPaging()) {
                return false;
            }
            this.cachedNext = this.next();
            return this.cachedNext != null;
        }

        @Override
        public void remove() {
            PageSubscriptionImpl.this.deliveredCount.incrementAndGet();
            PageSubscriptionImpl.this.getPageInfo(this.position).remove(this.position);
        }

        @Override
        public void close() {
        }
    }

    static class PageCursorTX
    extends TransactionOperationAbstract {
        HashMap<PageSubscriptionImpl, List<PagePosition>> pendingPositions = new HashMap();

        PageCursorTX() {
        }

        public void addPositionConfirmation(PageSubscriptionImpl cursor, PagePosition position) {
            List<PagePosition> list = this.pendingPositions.get(cursor);
            if (list == null) {
                list = new LinkedList<PagePosition>();
                this.pendingPositions.put(cursor, list);
            }
            list.add(position);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Map.Entry<PageSubscriptionImpl, List<PagePosition>> entry : this.pendingPositions.entrySet()) {
                PageSubscriptionImpl cursor = entry.getKey();
                List<PagePosition> positions = entry.getValue();
                for (PagePosition confirmed : positions) {
                    cursor.processACK(confirmed);
                    cursor.deliveredCount.decrementAndGet();
                }
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }
    }

    private class PageCursorInfo {
        private final int numberOfMessages;
        private final long pageId;
        private final Set<PagePosition> acks = Collections.synchronizedSet(new LinkedHashSet());
        private WeakReference<PageCache> cache;
        private Set<PagePosition> removedReferences = new ConcurrentHashSet<PagePosition>();
        private final boolean wasLive;
        private AtomicInteger pendingTX = new AtomicInteger(0);
        private boolean pendingDelete;
        private final AtomicInteger confirmed = new AtomicInteger(0);

        public String toString() {
            return "PageCursorInfo::PageID=" + this.pageId + " numberOfMessage = " + this.numberOfMessages + ", confirmed = " + this.confirmed;
        }

        public PageCursorInfo(long pageId, int numberOfMessages, PageCache cache) {
            this.pageId = pageId;
            this.numberOfMessages = numberOfMessages;
            this.wasLive = cache.isLive();
            if (this.wasLive) {
                this.cache = new WeakReference<PageCache>(cache);
            }
        }

        public boolean isDone() {
            return this.getNumberOfMessages() == this.confirmed.get() && this.pendingTX.get() == 0;
        }

        public boolean isPendingDelete() {
            return this.pendingDelete;
        }

        public void setPendingDelete() {
            this.pendingDelete = true;
        }

        public long getPageId() {
            return this.pageId;
        }

        public void incrementPendingTX() {
            this.pendingTX.incrementAndGet();
        }

        public void decrementPendingTX() {
            this.pendingTX.decrementAndGet();
            this.checkDone();
        }

        public boolean isRemoved(PagePosition pos) {
            return this.removedReferences.contains(pos);
        }

        public void remove(PagePosition position) {
            this.removedReferences.add(position);
        }

        public void addACK(PagePosition posACK) {
            if (PageSubscriptionImpl.this.isTrace) {
                PageSubscriptionImpl.trace("numberOfMessages =  " + this.getNumberOfMessages() + " confirmed =  " + (this.confirmed.get() + 1) + " pendingTX = " + this.pendingTX + ", page = " + this.pageId + " posACK = " + posACK);
            }
            this.removedReferences.add(posACK);
            boolean added = this.acks.add(posACK);
            if (added && posACK.getMessageNr() >= 0) {
                this.confirmed.incrementAndGet();
                this.checkDone();
            }
        }

        protected void checkDone() {
            if (this.isDone()) {
                PageSubscriptionImpl.this.onPageDone(this);
            }
        }

        private int getNumberOfMessages() {
            if (this.wasLive) {
                PageCache cache = (PageCache)this.cache.get();
                if (cache != null) {
                    return cache.getNumberOfMessages();
                }
                cache = PageSubscriptionImpl.this.cursorProvider.getPageCache(new PagePositionImpl(this.pageId, 0));
                this.cache = new WeakReference<PageCache>(cache);
                return cache.getNumberOfMessages();
            }
            return this.numberOfMessages;
        }
    }
}

