/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.exception.HornetQXAException;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.server.BindingQueryResult;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueQueryResult;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.impl.RoutingContextImpl;
import org.hornetq.core.server.impl.ServerConsumerImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUID;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class ServerSessionImpl
implements ServerSession,
FailureListener {
    private static final Logger log = Logger.getLogger(ServerSessionImpl.class);
    private final String username;
    private final String password;
    private final int minLargeMessageSize;
    private final boolean autoCommitSends;
    private final boolean autoCommitAcks;
    private final boolean preAcknowledge;
    private final boolean strictUpdateDeliveryCount;
    private RemotingConnection remotingConnection;
    private final Map<Long, ServerConsumer> consumers = new ConcurrentHashMap<Long, ServerConsumer>();
    private Transaction tx;
    private final boolean xa;
    private final StorageManager storageManager;
    private final ResourceManager resourceManager;
    public final PostOffice postOffice;
    private final SecurityStore securityStore;
    private final ManagementService managementService;
    private volatile boolean started = false;
    private final Map<SimpleString, TempQueueCleanerUpper> tempQueueCleannerUppers = new HashMap<SimpleString, TempQueueCleanerUpper>();
    private final String name;
    private final HornetQServer server;
    private final SimpleString managementAddress;
    private volatile LargeServerMessage currentLargeMessage;
    private final RoutingContext routingContext = new RoutingContextImpl(null);
    private final SessionCallback callback;
    private volatile SimpleString defaultAddress;
    private volatile int timeoutSeconds;
    private Map<String, String> metaData;
    private OperationContext sessionContext;
    private Map<SimpleString, Pair<UUID, AtomicLong>> targetAddressInfos = new HashMap<SimpleString, Pair<UUID, AtomicLong>>();
    private long creationTime = System.currentTimeMillis();

    public ServerSessionImpl(String name, String username, String password, int minLargeMessageSize, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean strictUpdateDeliveryCount, boolean xa, RemotingConnection remotingConnection, StorageManager storageManager, PostOffice postOffice, ResourceManager resourceManager, SecurityStore securityStore, ManagementService managementService, HornetQServer server, SimpleString managementAddress, SimpleString defaultAddress, SessionCallback callback) throws Exception {
        this.username = username;
        this.password = password;
        this.minLargeMessageSize = minLargeMessageSize;
        this.autoCommitSends = autoCommitSends;
        this.autoCommitAcks = autoCommitAcks;
        this.preAcknowledge = preAcknowledge;
        this.remotingConnection = remotingConnection;
        this.storageManager = storageManager;
        this.postOffice = postOffice;
        this.resourceManager = resourceManager;
        this.securityStore = securityStore;
        this.timeoutSeconds = resourceManager.getTimeoutSeconds();
        if (!xa) {
            this.tx = new TransactionImpl(storageManager, this.timeoutSeconds);
        }
        this.xa = xa;
        this.strictUpdateDeliveryCount = strictUpdateDeliveryCount;
        this.managementService = managementService;
        this.name = name;
        this.server = server;
        this.managementAddress = managementAddress;
        this.callback = callback;
        this.defaultAddress = defaultAddress;
        remotingConnection.addFailureListener(this);
    }

    @Override
    public OperationContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public void setSessionContext(OperationContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getConnectionID() {
        return this.remotingConnection.getID();
    }

    @Override
    public Set<ServerConsumer> getServerConsumers() {
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        return Collections.unmodifiableSet(consumersClone);
    }

    @Override
    public void removeConsumer(long consumerID) throws Exception {
        if (this.consumers.remove(consumerID) == null) {
            throw new IllegalStateException("Cannot find consumer with id " + consumerID + " to remove");
        }
    }

    private synchronized void doClose(boolean failed) throws Exception {
        if (this.tx != null && this.tx.getXid() == null) {
            this.rollback(failed);
        }
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            consumer.close(failed);
        }
        this.consumers.clear();
        this.server.removeSession(this.name);
        if (this.currentLargeMessage != null) {
            try {
                this.currentLargeMessage.deleteFile();
            }
            catch (Throwable error) {
                log.error("Failed to delete large message file", error);
            }
        }
        this.remotingConnection.removeFailureListener(this);
        this.callback.closed();
    }

    @Override
    public void createConsumer(long consumerID, SimpleString queueName, SimpleString filterString, boolean browseOnly) throws Exception {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null || binding.getType() != BindingType.LOCAL_QUEUE) {
            throw new HornetQException(100, "Queue " + queueName + " does not exist");
        }
        this.securityStore.check(binding.getAddress(), CheckType.CONSUME, this);
        Filter filter = FilterImpl.createFilter(filterString);
        ServerConsumerImpl consumer = new ServerConsumerImpl(consumerID, this, (QueueBinding)binding, filter, this.started, browseOnly, this.storageManager, this.callback, this.preAcknowledge, this.strictUpdateDeliveryCount, this.managementService);
        this.consumers.put(consumer.getID(), consumer);
        if (!browseOnly) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
            Queue theQueue = (Queue)binding.getBindable();
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, theQueue.getConsumerCount());
            if (filterString != null) {
                props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
            }
            Notification notification = new Notification(null, NotificationType.CONSUMER_CREATED, props);
            this.managementService.sendNotification(notification);
        }
    }

    @Override
    public void createQueue(SimpleString address, SimpleString name, SimpleString filterString, boolean temporary, boolean durable) throws Exception {
        if (durable) {
            this.securityStore.check(address, CheckType.CREATE_DURABLE_QUEUE, this);
        } else {
            this.securityStore.check(address, CheckType.CREATE_NON_DURABLE_QUEUE, this);
        }
        Queue queue = this.server.createQueue(address, name, filterString, durable, temporary);
        if (temporary) {
            TempQueueCleanerUpper cleaner = new TempQueueCleanerUpper(this.postOffice, name, queue);
            this.remotingConnection.addCloseListener(cleaner);
            this.remotingConnection.addFailureListener(cleaner);
            this.tempQueueCleannerUppers.put(name, cleaner);
        }
    }

    public RemotingConnection getRemotingConnection() {
        return this.remotingConnection;
    }

    @Override
    public void deleteQueue(SimpleString name) throws Exception {
        Binding binding = this.postOffice.getBinding(name);
        if (binding == null || binding.getType() != BindingType.LOCAL_QUEUE) {
            throw new HornetQException(100);
        }
        this.server.destroyQueue(name, this);
        TempQueueCleanerUpper cleaner = this.tempQueueCleannerUppers.remove(name);
        if (cleaner != null) {
            this.remotingConnection.removeCloseListener(cleaner);
            this.remotingConnection.removeFailureListener(cleaner);
        }
    }

    @Override
    public QueueQueryResult executeQueueQuery(SimpleString name) throws Exception {
        QueueQueryResult response;
        if (name == null) {
            throw new IllegalArgumentException("Queue name is null");
        }
        Binding binding = this.postOffice.getBinding(name);
        if (binding != null && binding.getType() == BindingType.LOCAL_QUEUE) {
            Queue queue = (Queue)binding.getBindable();
            Filter filter = queue.getFilter();
            SimpleString filterString = filter == null ? null : filter.getFilterString();
            response = new QueueQueryResult(name, binding.getAddress(), queue.isDurable(), queue.isTemporary(), filterString, queue.getConsumerCount(), queue.getMessageCount());
        } else {
            response = name.equals(this.managementAddress) ? new QueueQueryResult(name, this.managementAddress, true, false, null, -1, -1L) : new QueueQueryResult();
        }
        return response;
    }

    @Override
    public BindingQueryResult executeBindingQuery(SimpleString address) throws Exception {
        if (address == null) {
            throw new IllegalArgumentException("Address is null");
        }
        ArrayList<SimpleString> names = new ArrayList<SimpleString>();
        if (address.equals(this.managementAddress)) {
            return new BindingQueryResult(true, names);
        }
        Bindings bindings = this.postOffice.getMatchingBindings(address);
        for (Binding binding : bindings.getBindings()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE && binding.getType() != BindingType.REMOTE_QUEUE) continue;
            names.add(binding.getUniqueName());
        }
        return new BindingQueryResult(!names.isEmpty(), names);
    }

    @Override
    public void forceConsumerDelivery(long consumerID, long sequence) throws Exception {
        ServerConsumer consumer = this.consumers.get(consumerID);
        consumer.forceDelivery(sequence);
    }

    @Override
    public void acknowledge(long consumerID, long messageID) throws Exception {
        ServerConsumer consumer = this.consumers.get(consumerID);
        consumer.acknowledge(this.autoCommitAcks, this.tx, messageID);
    }

    @Override
    public void individualAcknowledge(long consumerID, long messageID) throws Exception {
        ServerConsumer consumer = this.consumers.get(consumerID);
        if (this.xa && this.tx == null) {
            throw new HornetQXAException(-6, "Invalid transaction state");
        }
        consumer.individualAcknowledge(this.autoCommitAcks, this.tx, messageID);
    }

    @Override
    public void expire(long consumerID, long messageID) throws Exception {
        MessageReference ref = this.consumers.get(consumerID).removeReferenceByID(messageID);
        if (ref != null) {
            ref.getQueue().expire(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws Exception {
        try {
            this.tx.commit();
        }
        finally {
            this.tx = new TransactionImpl(this.storageManager, this.timeoutSeconds);
        }
    }

    @Override
    public void rollback(boolean considerLastMessageAsDelivered) throws Exception {
        if (this.tx == null) {
            this.tx = new TransactionImpl(this.storageManager, this.timeoutSeconds);
        }
        this.doRollback(considerLastMessageAsDelivered, this.tx);
        this.tx = this.xa ? null : new TransactionImpl(this.storageManager, this.timeoutSeconds);
    }

    @Override
    public void xaCommit(Xid xid, boolean onePhase) throws Exception {
        if (this.tx != null && this.tx.getXid().equals(xid)) {
            String msg = "Cannot commit, session is currently doing work in transaction " + this.tx.getXid();
            throw new HornetQXAException(-6, msg);
        }
        Transaction theTx = this.resourceManager.removeTransaction(xid);
        if (theTx == null) {
            if (this.resourceManager.getHeuristicCommittedTransactions().contains(xid)) {
                throw new HornetQXAException(7, "transaction has been heuristically committed: " + xid);
            }
            if (this.resourceManager.getHeuristicRolledbackTransactions().contains(xid)) {
                throw new HornetQXAException(6, "transaction has been heuristically rolled back: " + xid);
            }
            throw new HornetQXAException(-4, "Cannot find xid in resource manager: " + xid);
        }
        if (theTx.getState() == Transaction.State.SUSPENDED) {
            this.resourceManager.putTransaction(xid, theTx);
            throw new HornetQXAException(-6, "Cannot commit transaction, it is suspended " + xid);
        }
        theTx.commit(onePhase);
    }

    @Override
    public void xaEnd(Xid xid) throws Exception {
        if (this.tx != null && this.tx.getXid().equals(xid)) {
            if (this.tx.getState() == Transaction.State.SUSPENDED) {
                String msg = "Cannot end, transaction is suspended";
                throw new HornetQXAException(-6, "Cannot end, transaction is suspended");
            }
            this.tx = null;
        } else {
            Transaction theTx = this.resourceManager.getTransaction(xid);
            if (theTx == null) {
                String msg = "Cannot find suspended transaction to end " + xid;
                throw new HornetQXAException(-4, msg);
            }
            if (theTx.getState() != Transaction.State.SUSPENDED) {
                String msg = "Transaction is not suspended " + xid;
                throw new HornetQXAException(-6, msg);
            }
            theTx.resume();
        }
    }

    @Override
    public void xaForget(Xid xid) throws Exception {
        long id = this.resourceManager.removeHeuristicCompletion(xid);
        if (id != -1L) {
            try {
                this.storageManager.deleteHeuristicCompletion(id);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HornetQXAException(-3);
            }
        } else {
            throw new HornetQXAException(-4);
        }
    }

    @Override
    public void xaJoin(Xid xid) throws Exception {
        Transaction theTx = this.resourceManager.getTransaction(xid);
        if (theTx == null) {
            String msg = "Cannot find xid in resource manager: " + xid;
            throw new HornetQXAException(-4, msg);
        }
        if (theTx.getState() == Transaction.State.SUSPENDED) {
            throw new HornetQXAException(-6, "Cannot join tx, it is suspended " + xid);
        }
        this.tx = theTx;
    }

    @Override
    public void xaResume(Xid xid) throws Exception {
        if (this.tx != null) {
            String msg = "Cannot resume, session is currently doing work in a transaction " + this.tx.getXid();
            throw new HornetQXAException(-6, msg);
        }
        Transaction theTx = this.resourceManager.getTransaction(xid);
        if (theTx == null) {
            String msg = "Cannot find xid in resource manager: " + xid;
            throw new HornetQXAException(-4, msg);
        }
        if (theTx.getState() != Transaction.State.SUSPENDED) {
            throw new HornetQXAException(-6, "Cannot resume transaction, it is not suspended " + xid);
        }
        this.tx = theTx;
        this.tx.resume();
    }

    @Override
    public void xaRollback(Xid xid) throws Exception {
        if (this.tx != null && this.tx.getXid().equals(xid)) {
            String msg = "Cannot roll back, session is currently doing work in a transaction " + this.tx.getXid();
            throw new HornetQXAException(-6, msg);
        }
        Transaction theTx = this.resourceManager.removeTransaction(xid);
        if (theTx == null) {
            if (this.resourceManager.getHeuristicCommittedTransactions().contains(xid)) {
                throw new HornetQXAException(7, "transaction has ben heuristically committed: " + xid);
            }
            if (this.resourceManager.getHeuristicRolledbackTransactions().contains(xid)) {
                throw new HornetQXAException(6, "transaction has ben heuristically rolled back: " + xid);
            }
            throw new HornetQXAException(-4, "Cannot find xid in resource manager: " + xid);
        }
        if (theTx.getState() == Transaction.State.SUSPENDED) {
            this.resourceManager.putTransaction(xid, this.tx);
            throw new HornetQXAException(-6, "Cannot rollback transaction, it is suspended " + xid);
        }
        this.doRollback(false, theTx);
    }

    @Override
    public void xaStart(Xid xid) throws Exception {
        if (this.tx != null) {
            String msg = "Cannot start, session is already doing work in a transaction " + this.tx.getXid();
            throw new HornetQXAException(-6, msg);
        }
        this.tx = new TransactionImpl(xid, this.storageManager, this.timeoutSeconds);
        boolean added = this.resourceManager.putTransaction(xid, this.tx);
        if (!added) {
            String msg = "Cannot start, there is already a xid " + this.tx.getXid();
            throw new HornetQXAException(-8, msg);
        }
    }

    @Override
    public void xaSuspend() throws Exception {
        if (this.tx == null) {
            String msg = "Cannot suspend, session is not doing work in a transaction ";
            throw new HornetQXAException(-6, "Cannot suspend, session is not doing work in a transaction ");
        }
        if (this.tx.getState() == Transaction.State.SUSPENDED) {
            String msg = "Cannot suspend, transaction is already suspended " + this.tx.getXid();
            throw new HornetQXAException(-6, msg);
        }
        this.tx.suspend();
        this.tx = null;
    }

    @Override
    public void xaPrepare(Xid xid) throws Exception {
        if (this.tx != null && this.tx.getXid().equals(xid)) {
            String msg = "Cannot commit, session is currently doing work in a transaction " + this.tx.getXid();
            throw new HornetQXAException(-6, msg);
        }
        Transaction theTx = this.resourceManager.getTransaction(xid);
        if (theTx == null) {
            String msg = "Cannot find xid in resource manager: " + xid;
            throw new HornetQXAException(-4, msg);
        }
        if (theTx.getState() == Transaction.State.SUSPENDED) {
            throw new HornetQXAException(-6, "Cannot prepare transaction, it is suspended " + xid);
        }
        if (theTx.getState() == Transaction.State.PREPARED) {
            log.info("ignoring prepare on xid as already called :" + xid);
        } else {
            theTx.prepare();
        }
    }

    @Override
    public List<Xid> xaGetInDoubtXids() {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        xids.addAll(this.resourceManager.getPreparedTransactions());
        xids.addAll(this.resourceManager.getHeuristicCommittedTransactions());
        xids.addAll(this.resourceManager.getHeuristicRolledbackTransactions());
        return xids;
    }

    @Override
    public int xaGetTimeout() {
        return this.resourceManager.getTimeoutSeconds();
    }

    @Override
    public void xaSetTimeout(int timeout) {
        this.timeoutSeconds = timeout;
        if (this.tx != null) {
            this.tx.setTimeout(timeout);
        }
    }

    @Override
    public void start() {
        this.setStarted(true);
    }

    @Override
    public void stop() {
        this.setStarted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitContextCompletion() {
        OperationContext formerCtx = this.storageManager.getContext();
        try {
            try {
                if (!this.storageManager.waitOnOperations(10000L)) {
                    log.warn("Couldn't finish context execution in 10 seconds", new Exception("warning"));
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), e);
            }
        }
        finally {
            this.storageManager.setContext(formerCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(final boolean failed) {
        OperationContext formerCtx = this.storageManager.getContext();
        try {
            this.storageManager.setContext(this.sessionContext);
            this.storageManager.afterCompleteOperations(new IOAsyncTask(){

                @Override
                public void onError(int errorCode, String errorMessage) {
                }

                @Override
                public void done() {
                    try {
                        ServerSessionImpl.this.doClose(failed);
                    }
                    catch (Exception e) {
                        log.error("Failed to close session", e);
                    }
                }
            });
        }
        finally {
            this.storageManager.setContext(formerCtx);
        }
    }

    @Override
    public void closeConsumer(long consumerID) throws Exception {
        ServerConsumer consumer = this.consumers.get(consumerID);
        if (consumer != null) {
            consumer.close(false);
        } else {
            log.error("Cannot find consumer with id " + consumerID);
        }
    }

    @Override
    public void receiveConsumerCredits(long consumerID, int credits) throws Exception {
        ServerConsumer consumer = this.consumers.get(consumerID);
        if (consumer == null) {
            log.error("There is no consumer with id " + consumerID);
            return;
        }
        consumer.receiveCredits(credits);
    }

    @Override
    public void sendLarge(MessageInternal message) throws Exception {
        long id = this.storageManager.generateUniqueID();
        LargeServerMessage largeMsg = this.storageManager.createLargeMessage(id, message);
        if (this.currentLargeMessage != null) {
            log.warn("Replacing incomplete LargeMessage with ID=" + this.currentLargeMessage.getMessageID());
        }
        this.currentLargeMessage = largeMsg;
    }

    @Override
    public void send(ServerMessage message, boolean direct) throws Exception {
        long id = this.storageManager.generateUniqueID();
        SimpleString address = message.getAddress();
        message.setMessageID(id);
        message.encodeMessageIDToBuffer();
        if (address == null) {
            if (message.isDurable()) {
                message.setAddress(this.defaultAddress);
            } else {
                message.setAddressTransient(this.defaultAddress);
            }
        }
        if (message.getAddress().equals(this.managementAddress)) {
            this.handleManagementMessage(message, direct);
        } else {
            this.doSend(message, direct);
        }
        if (this.defaultAddress == null) {
            this.defaultAddress = address;
        }
    }

    @Override
    public void sendContinuations(int packetSize, long messageBodySize, byte[] body, boolean continues) throws Exception {
        if (this.currentLargeMessage == null) {
            throw new HornetQException(104, "large-message not initialized on server");
        }
        this.currentLargeMessage.addBytes(body);
        if (!continues) {
            this.currentLargeMessage.releaseResources();
            if (messageBodySize >= 0L) {
                this.currentLargeMessage.putLongProperty(Message.HDR_LARGE_BODY_SIZE, messageBodySize);
            }
            this.doSend(this.currentLargeMessage, false);
            this.currentLargeMessage = null;
        }
    }

    @Override
    public void requestProducerCredits(final SimpleString address, final int credits) throws Exception {
        PagingStore store = this.postOffice.getPagingManager().getPageStore(address);
        store.executeRunnableWhenMemoryAvailable(new Runnable(){

            @Override
            public void run() {
                ServerSessionImpl.this.callback.sendProducerCreditsMessage(credits, address);
            }
        });
    }

    @Override
    public void setTransferring(boolean transferring) {
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            consumer.setTransferring(transferring);
        }
    }

    @Override
    public void addMetaData(String key, String data) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, String>();
        }
        this.metaData.put(key, data);
    }

    @Override
    public String getMetaData(String key) {
        String data = null;
        if (this.metaData != null) {
            data = this.metaData.get(key);
        }
        return data;
    }

    @Override
    public String[] getTargetAddresses() {
        Map<SimpleString, Pair<UUID, AtomicLong>> copy = this.cloneTargetAddresses();
        Iterator<SimpleString> iter = copy.keySet().iterator();
        int num = copy.keySet().size();
        String[] addresses = new String[num];
        int i = 0;
        while (iter.hasNext()) {
            addresses[i] = iter.next().toString();
            ++i;
        }
        return addresses;
    }

    @Override
    public String getLastSentMessageID(String address) {
        Pair<UUID, AtomicLong> value = this.targetAddressInfos.get(SimpleString.toSimpleString(address));
        if (value != null) {
            return ((UUID)value.a).toString();
        }
        return null;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void describeProducersInfo(JSONArray array) throws Exception {
        Map<SimpleString, Pair<UUID, AtomicLong>> targetCopy = this.cloneTargetAddresses();
        for (Map.Entry<SimpleString, Pair<UUID, AtomicLong>> entry : targetCopy.entrySet()) {
            JSONObject producerInfo = new JSONObject();
            producerInfo.put("connectionID", this.getConnectionID().toString());
            producerInfo.put("sessionID", this.getName());
            producerInfo.put("destination", entry.getKey().toString());
            producerInfo.put("lastUUIDSent", entry.getValue().a);
            producerInfo.put("msgSent", ((AtomicLong)entry.getValue().b).longValue());
            array.put(producerInfo);
        }
    }

    @Override
    public void connectionFailed(HornetQException me, boolean failedOver) {
        try {
            log.warn("Client connection failed, clearing up resources for session " + this.name);
            this.close(true);
            log.warn("Cleared up resources for session " + this.name);
        }
        catch (Throwable t) {
            log.error("Failed to close connection " + this);
        }
    }

    private Map<SimpleString, Pair<UUID, AtomicLong>> cloneTargetAddresses() {
        return new HashMap<SimpleString, Pair<UUID, AtomicLong>>(this.targetAddressInfos);
    }

    private void setStarted(boolean s) {
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            consumer.setStarted(s);
        }
        this.started = s;
    }

    private void handleManagementMessage(ServerMessage message, boolean direct) throws Exception {
        try {
            this.securityStore.check(message.getAddress(), CheckType.MANAGE, this);
        }
        catch (HornetQException e) {
            if (!this.autoCommitSends) {
                this.tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        ServerMessage reply = this.managementService.handleMessage(message);
        SimpleString replyTo = message.getSimpleStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME);
        if (replyTo != null) {
            reply.setAddress(replyTo);
            this.doSend(reply, direct);
        }
    }

    private void doRollback(boolean lastMessageAsDelived, Transaction theTx) throws Exception {
        boolean wasStarted = this.started;
        ArrayList<MessageReference> toCancel = new ArrayList<MessageReference>();
        for (ServerConsumer consumer : this.consumers.values()) {
            if (wasStarted) {
                consumer.setStarted(false);
            }
            toCancel.addAll(consumer.cancelRefs(false, lastMessageAsDelived, theTx));
        }
        for (MessageReference ref : toCancel) {
            ref.getQueue().cancel(theTx, ref);
        }
        theTx.rollback();
        if (wasStarted) {
            for (ServerConsumer consumer : this.consumers.values()) {
                consumer.setStarted(true);
            }
        }
    }

    private void doSend(ServerMessage msg, boolean direct) throws Exception {
        try {
            this.securityStore.check(msg.getAddress(), CheckType.SEND, this);
        }
        catch (HornetQException e) {
            if (!this.autoCommitSends) {
                this.tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        if (this.tx != null && !this.autoCommitSends) {
            this.routingContext.setTransaction(this.tx);
        }
        this.postOffice.route(msg, this.routingContext, direct);
        Pair<UUID, AtomicLong> value = this.targetAddressInfos.get(msg.getAddress());
        if (value == null) {
            this.targetAddressInfos.put(msg.getAddress(), new Pair<UUID, AtomicLong>(msg.getUserID(), new AtomicLong(1L)));
        } else {
            value.a = msg.getUserID();
            ((AtomicLong)value.b).incrementAndGet();
        }
        this.routingContext.clear();
    }

    private static class TempQueueCleanerUpper
    implements CloseListener,
    FailureListener {
        private final PostOffice postOffice;
        private final SimpleString bindingName;
        private final Queue queue;

        TempQueueCleanerUpper(PostOffice postOffice, SimpleString bindingName, Queue queue) {
            this.postOffice = postOffice;
            this.bindingName = bindingName;
            this.queue = queue;
        }

        private void run() {
            try {
                if (this.postOffice.getBinding(this.bindingName) != null) {
                    this.postOffice.removeBinding(this.bindingName);
                }
                this.queue.deleteAllReferences();
            }
            catch (Exception e) {
                log.error("Failed to remove temporary queue " + this.bindingName);
            }
        }

        @Override
        public void connectionFailed(HornetQException exception, boolean failedOver) {
            this.run();
        }

        @Override
        public void connectionClosed() {
            this.run();
        }

        public String toString() {
            return "Temporary Cleaner for queue " + this.bindingName;
        }
    }
}

