/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.jboss.classfilewriter.AccessFlag;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.code.CodeLocation;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.invocation.proxy.AbstractSubclassFactory;

public abstract class AbstractProxyFactory<T>
extends AbstractSubclassFactory<T> {
    private static final String METHOD_FIELD_PREFIX = "METHOD$$IDENTIFIER";
    private static final String METHOD_FIELD_DESCRIPTOR = "Ljava/lang/reflect/Method;";
    private final Map<Method, String> methodIdentifiers = new HashMap<Method, String>();
    private int identifierCount = 0;
    private ClassMethod staticConstructor = this.classFile.addMethod(AccessFlag.of((int[])new int[]{1, 8}), "<clinit>", "V", new String[0]);

    protected AbstractProxyFactory(String className, Class<T> superClass, ClassLoader classLoader) {
        super(className, superClass, classLoader);
    }

    protected AbstractProxyFactory(String className, Class<T> superClass, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        super(className, superClass, classLoader, protectionDomain);
    }

    protected AbstractProxyFactory(String className, Class<T> superClass) {
        super(className, superClass);
    }

    protected void finalizeStaticConstructor() {
        this.staticConstructor.getCodeAttribute().returnInstruction();
    }

    @Override
    public void afterClassLoad(Class<?> clazz) {
        super.afterClassLoad(clazz);
        AccessController.doPrivileged(new MethodAccessibilitySetter());
    }

    public Method[] getCachedMethods() {
        return this.getCachedMethods(this.defineClass());
    }

    public Method[] getCachedMethods(Class<?> clazz) {
        if (!this.getClassName().equals(clazz.getName())) {
            throw new IllegalArgumentException(clazz + " is not a proxy generated by this ProxyFactory: " + this.getClassName());
        }
        return AccessController.doPrivileged(new CachedMethodGetter());
    }

    @Override
    protected void cleanup() {
        this.staticConstructor = null;
        super.cleanup();
    }

    protected void loadMethodIdentifier(Method methodToLoad, ClassMethod method) {
        if (!this.methodIdentifiers.containsKey(methodToLoad)) {
            int identifierNo = this.identifierCount++;
            String fieldName = METHOD_FIELD_PREFIX + identifierNo;
            this.classFile.addField(10, fieldName, Method.class);
            this.methodIdentifiers.put(methodToLoad, fieldName);
            CodeAttribute ca = this.staticConstructor.getCodeAttribute();
            ca.loadClass(methodToLoad.getDeclaringClass().getName());
            ca.invokevirtual("java.lang.Class", "getDeclaredMethods", "()[Ljava/lang/reflect/Method;");
            ca.dup();
            ca.arraylength();
            ca.dup();
            ca.istore(0);
            ca.aconstNull();
            ca.astore(1);
            ca.aconstNull();
            ca.astore(2);
            ca.aconstNull();
            ca.astore(3);
            CodeLocation loopBegin = ca.mark();
            BranchEnd loopEnd = ca.ifeq();
            ca.dup();
            ca.iinc(0, -1);
            ca.iload(0);
            ca.dupX1();
            ca.aaload();
            ca.checkcast("java.lang.reflect.Method");
            ca.dup();
            ca.astore(2);
            ca.invokevirtual("java.lang.reflect.Method", "getName", "()Ljava/lang/String;");
            ca.ldc(methodToLoad.getName());
            ca.invokevirtual("java.lang.Object", "equals", "(Ljava/lang/Object;)Z");
            ca.ifEq(loopBegin);
            ca.aload(2);
            ca.invokevirtual("java.lang.reflect.Method", "getReturnType", "()Ljava/lang/Class;");
            ca.loadType(DescriptorUtils.makeDescriptor(methodToLoad.getReturnType()));
            ca.invokevirtual("java.lang.Object", "equals", "(Ljava/lang/Object;)Z");
            ca.ifEq(loopBegin);
            Class<?>[] parameters = methodToLoad.getParameterTypes();
            ca.aload(2);
            ca.invokevirtual("java.lang.reflect.Method", "getParameterTypes", "()[Ljava/lang/Class;");
            ca.dup();
            ca.astore(3);
            ca.arraylength();
            ca.iconst(parameters.length);
            ca.ifIcmpne(loopBegin);
            for (int i = 0; i < parameters.length; ++i) {
                ca.aload(3);
                ca.iconst(i);
                ca.aaload();
                ca.loadType(DescriptorUtils.makeDescriptor(parameters[i]));
                ca.invokevirtual("java.lang.Object", "equals", "(Ljava/lang/Object;)Z");
                ca.ifEq(loopBegin);
            }
            ca.pop();
            BranchEnd gotoEnd = ca.gotoInstruction();
            ca.branchEnd(loopEnd);
            ca.newInstruction("java.lang.RuntimeException");
            ca.dup();
            ca.ldc("Could not find method " + methodToLoad);
            ca.invokespecial("java.lang.RuntimeException", "<init>", "(Ljava/lang/String;)V");
            ca.athrow();
            ca.branchEnd(gotoEnd);
            ca.pop();
            ca.aload(2);
            ca.checkcast("java.lang.reflect.Method");
            ca.putstatic(this.getClassName(), fieldName, METHOD_FIELD_DESCRIPTOR);
        }
        String fieldName = this.methodIdentifiers.get(methodToLoad);
        method.getCodeAttribute().getstatic(this.getClassName(), fieldName, METHOD_FIELD_DESCRIPTOR);
    }

    private class CachedMethodGetter
    implements PrivilegedAction<Method[]> {
        private CachedMethodGetter() {
        }

        @Override
        public Method[] run() {
            Method[] methods = new Method[AbstractProxyFactory.this.identifierCount];
            Class clazz = AbstractProxyFactory.this.defineClass();
            for (int i = 0; i < AbstractProxyFactory.this.identifierCount; ++i) {
                try {
                    Field field = clazz.getDeclaredField(AbstractProxyFactory.METHOD_FIELD_PREFIX + i);
                    field.setAccessible(true);
                    methods[i] = (Method)field.get(null);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return methods;
        }
    }

    private class MethodAccessibilitySetter
    implements PrivilegedAction<Void> {
        private MethodAccessibilitySetter() {
        }

        @Override
        public Void run() {
            Class clazz = AbstractProxyFactory.this.defineClass();
            for (int i = 0; i < AbstractProxyFactory.this.identifierCount; ++i) {
                try {
                    Field field = clazz.getDeclaredField(AbstractProxyFactory.METHOD_FIELD_PREFIX + i);
                    field.setAccessible(true);
                    Method method = (Method)field.get(null);
                    method.setAccessible(true);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }
}

