/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.common;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.JCAMetadata;

public interface CommonTimeOut
extends JCAMetadata {
    public Long getBlockingTimeoutMillis();

    public Long getIdleTimeoutMinutes();

    public Integer getAllocationRetry();

    public Long getAllocationRetryWaitMillis();

    public Integer getXaResourceTimeout();

    public static enum Tag {
        UNKNOWN(null),
        BLOCKINGTIMEOUTMILLIS("blocking-timeout-millis"),
        IDLETIMEOUTMINUTES("idle-timeout-minutes"),
        XARESOURCETIMEOUT("xa-resource-timeout"),
        ALLOCATIONRETRY("allocation-retry"),
        ALLOCATIONRETRYWAITMILLIS("allocation-retry-wait-millis");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

