/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.common.type.Classes;
import org.switchyard.component.soap.BaseWebService;
import org.switchyard.component.soap.DefaultMessageComposer;
import org.switchyard.component.soap.DefaultMessageDecomposer;
import org.switchyard.component.soap.MessageComposer;
import org.switchyard.component.soap.MessageDecomposer;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.exception.DeliveryException;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.w3c.dom.Node;

public class InboundHandler
extends BaseHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final String MESSAGE_NAME = "MESSAGE_NAME";
    private static final String WSDL_LOCATION = "javax.xml.ws.wsdl.description";
    private final ConcurrentHashMap<String, BaseExchangeContract> _contracts = new ConcurrentHashMap();
    private MessageComposer _composer;
    private Set<QName> _composerMappedHeaderNames = new LinkedHashSet<QName>();
    private MessageDecomposer _decomposer;
    private Set<QName> _decomposerMappedVariableNames = new LinkedHashSet<QName>();
    private ServiceReference _service;
    private long _waitTimeout = 15000L;
    private Endpoint _endpoint;
    private Port _wsdlPort;
    private String _scheme = "http";
    private SOAPBindingModel _config;

    public InboundHandler(SOAPBindingModel config) {
        this._config = config;
        this._composerMappedHeaderNames.addAll(config.getComposerMappedVariableNames());
        this._decomposerMappedVariableNames.addAll(config.getDecomposerMappedVariableNames());
        String composer = config.getComposer();
        String decomposer = config.getDecomposer();
        if (composer != null && composer.length() > 0) {
            try {
                Class<MessageComposer> composerClass = Classes.forName((String)composer, ((Object)((Object)this)).getClass()).asSubclass(MessageComposer.class);
                this._composer = composerClass.newInstance();
            }
            catch (Exception cnfe) {
                LOGGER.error((Object)"Could not instantiate composer", (Throwable)cnfe);
            }
        }
        if (this._composer == null) {
            this._composer = new DefaultMessageComposer();
        }
        if (decomposer != null && decomposer.length() > 0) {
            try {
                Class<MessageDecomposer> decomposerClass = Classes.forName((String)decomposer, ((Object)((Object)this)).getClass()).asSubclass(MessageDecomposer.class);
                this._decomposer = decomposerClass.newInstance();
            }
            catch (Exception cnfe) {
                LOGGER.error((Object)"Could not instantiate decomposer", (Throwable)cnfe);
            }
        }
        if (this._decomposer == null) {
            this._decomposer = new DefaultMessageDecomposer();
        }
    }

    public void start(ServiceReference service) throws WebServicePublishException {
        try {
            this._service = service;
            PortName portName = this._config.getPort();
            Service wsdlService = WSDLUtil.getService(this._config.getWsdl(), portName);
            this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
            portName.setServiceQName(wsdlService.getQName());
            portName.setName(this._wsdlPort.getName());
            BaseWebService wsProvider = new BaseWebService();
            wsProvider.setInvocationClassLoader(Thread.currentThread().getContextClassLoader());
            wsProvider.setConsumer(this);
            this._contracts.putAll(WSDLUtil.getContracts(this._wsdlPort, service));
            this._endpoint = Endpoint.create((Object)wsProvider);
            ArrayList<StreamSource> metadata = new ArrayList<StreamSource>();
            StreamSource source = WSDLUtil.getStream(this._config.getWsdl());
            metadata.add(source);
            this._endpoint.setMetadata(metadata);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("javax.xml.ws.wsdl.service", portName.getServiceQName());
            properties.put("javax.xml.ws.wsdl.port", portName.getPortQName());
            properties.put(WSDL_LOCATION, this._config.getWsdl());
            this._endpoint.setProperties(properties);
            String path = "/" + portName.getServiceName();
            if (this._config.getContextPath() != null) {
                path = "/" + this._config.getContextPath() + "/" + portName.getServiceName();
            }
            String publishUrl = this._scheme + "://" + this._config.getServerHost() + ":" + this._config.getServerPort() + path;
            this._endpoint.publish(publishUrl);
            LOGGER.info((Object)("WebService published at " + publishUrl));
        }
        catch (WSDLException e) {
            throw new WebServicePublishException(e);
        }
    }

    public void stop() {
        this._composerMappedHeaderNames.clear();
        this._decomposerMappedVariableNames.clear();
        this._endpoint.stop();
        LOGGER.info((Object)("WebService " + this._config.getPort() + " stopped."));
    }

    public void handleFault(Exchange exchange) {
        throw new IllegalStateException("Unexpected");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw new IllegalStateException("Unexpected");
    }

    public SOAPMessage decompose(Exchange exchange) {
        try {
            return this._decomposer.decompose(exchange, this._decomposerMappedVariableNames);
        }
        catch (SOAPException se) {
            try {
                return SOAPUtil.generateFault(se);
            }
            catch (SOAPException e) {
                LOGGER.error((Object)e);
                return null;
            }
        }
    }

    public SOAPMessage invoke(SOAPMessage soapMessage) {
        Operation operation;
        String operationName = null;
        BaseExchangeContract exchangeContract = null;
        Boolean oneWay = false;
        String firstBodyElement = null;
        try {
            firstBodyElement = SOAPUtil.getFirstBodyElement(soapMessage);
            operation = WSDLUtil.getOperation(this._wsdlPort, firstBodyElement);
            if (operation != null) {
                operationName = operation.getName();
                oneWay = WSDLUtil.isOneWay(operation);
                exchangeContract = this._contracts.get(operationName);
            }
        }
        catch (SOAPException e) {
            LOGGER.error((Object)e);
            return null;
        }
        if (exchangeContract == null) {
            return this.handleException(oneWay, new SOAPException("Operation for '" + firstBodyElement + "' not available on target Service '" + this._service.getName() + "'."));
        }
        try {
            SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
            Exchange exchange = this._service.createExchange((ExchangeContract)exchangeContract, (ExchangeHandler)inOutHandler);
            Message message = this._composer.compose(soapMessage, exchange, this._composerMappedHeaderNames);
            this.assertComposedMessageOK(message, operation);
            exchange.getContext().setProperty(MESSAGE_NAME, (Object)operation.getInput().getMessage().getQName().getLocalPart(), Scope.IN);
            if (oneWay.booleanValue()) {
                exchange.send(message);
                return null;
            }
            exchange.send(message);
            try {
                exchange = inOutHandler.waitForOut(this._waitTimeout);
            }
            catch (DeliveryException e) {
                return this.handleException(oneWay, new SOAPException("Timed out after " + this._waitTimeout + " ms waiting on synchronous response from target service '" + this._service.getName() + "'."));
            }
            return this.decompose(exchange);
        }
        catch (SOAPException se) {
            return this.handleException(oneWay, se);
        }
    }

    private void assertComposedMessageOK(Message soapMessage, Operation operation) throws SOAPException {
        Node inputMessage = (Node)soapMessage.getContent(Node.class);
        if (inputMessage == null) {
            throw new SOAPException("Composer created a null ESB Message payload for service '" + this._service.getName() + "'.  Must be of type '" + SOAPMessage.class.getName() + "'.");
        }
        String actualNS = inputMessage.getNamespaceURI();
        String actualLN = inputMessage.getLocalName();
        List parts = operation.getInput().getMessage().getOrderedParts(null);
        if (parts.isEmpty()) {
            throw new SOAPException("Invalid input SOAP payload for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  No such Part '" + actualLN + "'.");
        }
        Part part = (Part)parts.get(0);
        QName expectedPayloadType = part.getElementName();
        String expectedNS = expectedPayloadType.getNamespaceURI();
        String expectedLN = expectedPayloadType.getLocalPart();
        if (expectedNS != null && !expectedNS.equals(actualNS)) {
            throw new SOAPException("Invalid input SOAP payload namespace for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation namespace as '" + expectedNS + "'.  Actual namespace on input SOAP message '" + actualNS + "'.");
        }
        if (expectedLN != null && !expectedLN.equals(actualLN)) {
            throw new SOAPException("Invalid input SOAP payload localNamePart for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation localNamePart as '" + expectedLN + "'.  Actual localNamePart on input SOAP message '" + actualLN + "'.");
        }
    }

    private SOAPMessage handleException(Boolean oneWay, SOAPException se) {
        if (oneWay.booleanValue()) {
            LOGGER.error((Object)se);
        } else {
            try {
                return SOAPUtil.generateFault(se);
            }
            catch (SOAPException e) {
                LOGGER.error((Object)e);
            }
        }
        return null;
    }
}

