/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.switchyard.common.xml.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SOAPUtil {
    private static final Logger LOGGER = Logger.getLogger(SOAPUtil.class);
    private static final QName SERVER_FAULT_QN = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    private static final boolean RETURN_STACK_TRACES = false;
    public static final MessageFactory SOAP_MESSAGE_FACTORY;

    private SOAPUtil() {
    }

    public static String getFirstBodyElement(SOAPMessage soapMessage) throws SOAPException {
        String operationName = null;
        SOAPBody body = soapMessage.getSOAPPart().getEnvelope().getBody();
        if (body != null) {
            Iterator nodes = body.getChildElements();
            Node node = null;
            while (nodes.hasNext()) {
                node = (Node)nodes.next();
                if (!(node instanceof Element)) continue;
                operationName = node.getLocalName();
            }
        }
        return operationName;
    }

    public static SOAPMessage generateFault(Throwable th) throws SOAPException {
        SOAPMessage faultMsg = SOAP_MESSAGE_FACTORY.createMessage();
        if (th instanceof SOAPFaultException) {
            SOAPFault exFault = ((SOAPFaultException)th).getFault();
            SOAPFault fault = faultMsg.getSOAPBody().addFault(exFault.getFaultCodeAsQName(), exFault.getFaultString());
            fault.addNamespaceDeclaration(fault.getElementQName().getPrefix(), SERVER_FAULT_QN.getNamespaceURI());
            fault.setFaultActor(exFault.getFaultActor());
            if (exFault.hasDetail()) {
                Detail exDetail = exFault.getDetail();
                Detail detail = fault.addDetail();
                Iterator entries = exDetail.getDetailEntries();
                while (entries.hasNext()) {
                    DetailEntry exEntry = (DetailEntry)entries.next();
                    DetailEntry entry = detail.addDetailEntry(exEntry.getElementName());
                    entry.setValue(exEntry.getValue());
                }
            }
        } else {
            String message = th.getMessage();
            if (message == null) {
                message = th.toString();
            }
            faultMsg.getSOAPBody().addFault(SERVER_FAULT_QN, message);
        }
        return faultMsg;
    }

    public static Document parseAsDom(String soapRes) throws ParserConfigurationException, XMLStreamException {
        XMLEventReader reader = XMLHelper.getXMLEventReader((InputStream)new ByteArrayInputStream(soapRes.getBytes()));
        return XMLHelper.createDocument((XMLEventReader)reader);
    }

    static {
        MessageFactory soapMessageFactory = null;
        try {
            soapMessageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException soape) {
            LOGGER.error((Object)"Could not instantiate SOAP Message Factory", (Throwable)soape);
        }
        SOAP_MESSAGE_FACTORY = soapMessageFactory;
    }
}

