/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.archive;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.milyn.archive.Archive;
import org.milyn.assertion.AssertArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveClassLoader
extends ClassLoader {
    private Archive archive;
    private Map<String, Class> loadedClasses = new HashMap<String, Class>();
    private File tempFile;

    public ArchiveClassLoader(Archive archive) {
        this(Thread.currentThread().getContextClassLoader(), archive);
    }

    public ArchiveClassLoader(ClassLoader parent, Archive archive) {
        super(parent);
        AssertArgument.isNotNull(archive, "archive");
        this.archive = archive;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.loadedClasses.get(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        String resName = name.replace('.', '/') + ".class";
        byte[] classBytes = this.archive.getEntries().get(resName);
        if (classBytes != null) {
            loadedClass = this.defineClass(name, classBytes, 0, classBytes.length);
            this.loadedClasses.put(name, loadedClass);
            return loadedClass;
        }
        return super.loadClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytes = this.archive.getEntries().get(name);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return super.getResourceAsStream(name);
    }

    @Override
    protected URL findResource(String resName) {
        URL resource = this.getResourceURL(resName);
        if (resource != null) {
            return resource;
        }
        return this.getParent().getResource(resName);
    }

    @Override
    protected Enumeration<URL> findResources(String resName) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        URL resource = this.getResourceURL(resName);
        if (resource != null) {
            resources.add(resource);
        }
        Enumeration<URL> parentResource = this.getParent().getResources(resName);
        resources.addAll(Collections.list(parentResource));
        return Collections.enumeration(resources);
    }

    private URL getResourceURL(String resName) {
        byte[] entry = this.archive.getEntries().get(resName);
        if (entry == null) {
            return null;
        }
        if (this.tempFile == null) {
            this.createTempJar();
        }
        try {
            return new URL("jar:" + this.tempFile.toURI() + "!/" + resName);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unable to create temporary archive jar file URL for resource '" + resName + "'.", e);
        }
    }

    public synchronized File createTempJar() {
        if (this.tempFile == null) {
            try {
                this.tempFile = File.createTempFile("smooks-archive", ".jar");
                this.tempFile.delete();
                this.archive.toFile(this.tempFile);
                this.tempFile.deleteOnExit();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create temporary jar file.", e);
            }
        }
        return this.tempFile;
    }
}

