/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.flatfile.variablefield;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.flatfile.BindingType;
import org.milyn.flatfile.FieldMetaData;
import org.milyn.flatfile.RecordMetaData;
import org.milyn.flatfile.RecordParserFactory;
import org.milyn.function.StringFunctionExecutor;
import org.milyn.javabean.Bean;
import org.milyn.javabean.context.BeanContext;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VariableFieldRecordParserFactory
implements RecordParserFactory,
VisitorAppender {
    @ConfigParam(defaultVal="##NULL")
    private String fields;
    private RecordMetaData recordMetaData;
    private Map<String, RecordMetaData> recordMetaDataMap;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String recordDelimiter;
    private Pattern recordDelimiterPattern;
    @ConfigParam(defaultVal="false")
    private boolean keepDelimiter;
    @ConfigParam(defaultVal="record")
    private String recordElementName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindBeanId;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Class<?> bindBeanClass;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private BindingType bindingType;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindMapKeyField;
    private static final String RECORD_BEAN = "recordBean";
    @ConfigParam(defaultVal="true")
    private boolean strict;
    private String overFlowFromLastRecord = "";
    public static final Pattern SINGLE_RECORD_PATTERN = Pattern.compile("^[\\w|[?$-_, ]]+$");
    public static final Pattern MULTI_RECORD_PATTERN = Pattern.compile("^([\\w|[?$-_*]]+)\\[([\\w|[?$-_, *]]+)\\]$");
    protected static RecordMetaData unknownVRecordType = new RecordMetaData("UNMATCHED", new ArrayList<FieldMetaData>());

    public boolean isMultiTypeRecordSet() {
        return this.recordMetaData == null && this.recordMetaDataMap != null;
    }

    public RecordMetaData getRecordMetaData() {
        if (this.isMultiTypeRecordSet()) {
            throw new IllegalStateException("Invalid call to getRecordMetaData().  This is a multi-type record set.  Must call getRecordMetaData(String recordTypeName).");
        }
        return this.recordMetaData;
    }

    public RecordMetaData getRecordMetaData(String recordTypeName) {
        AssertArgument.isNotNullAndNotEmpty(recordTypeName, "recordTypeName");
        if (!this.isMultiTypeRecordSet()) {
            throw new IllegalStateException("Invalid call to getRecordMetaData(String recordTypeName).  This is not a multi-type record set.  Must call getRecordMetaData().");
        }
        return this.recordMetaDataMap.get(recordTypeName);
    }

    public RecordMetaData getRecordMetaData(String[] record) {
        AssertArgument.isNotNullAndNotEmpty(record, "record");
        if (!this.isMultiTypeRecordSet()) {
            return this.recordMetaData;
        }
        return this.recordMetaDataMap.get(record[0].trim());
    }

    public RecordMetaData getRecordMetaData(Collection<String> record) {
        AssertArgument.isNotNullAndNotEmpty(record, "record");
        if (!this.isMultiTypeRecordSet()) {
            return this.recordMetaData;
        }
        RecordMetaData vrecordMetaData = this.recordMetaDataMap.get(record.iterator().next().trim());
        if (vrecordMetaData == null) {
            vrecordMetaData = unknownVRecordType;
        }
        return vrecordMetaData;
    }

    public String getRecordElementName() {
        return this.recordElementName;
    }

    public boolean strict() {
        return this.strict;
    }

    @Override
    public void addVisitors(VisitorConfigMap visitorMap) {
        if (this.bindBeanId != null && this.bindBeanClass != null) {
            if (this.isMultiTypeRecordSet()) {
                throw new SmooksConfigurationException("Unsupported reader based bean binding config for a multi record type record set.  Only supported for single record type record sets.  Use <jb:bean> configs for multi binding record type record sets.");
            }
            if (this.bindingType == BindingType.LIST) {
                Bean listBean = new Bean(ArrayList.class, this.bindBeanId, "#document");
                Bean bean = listBean.newBean(this.bindBeanClass, this.recordElementName);
                listBean.bindTo(bean);
                this.addFieldBindings(bean);
                listBean.addVisitors(visitorMap);
            } else if (this.bindingType == BindingType.MAP) {
                if (this.bindMapKeyField == null) {
                    throw new SmooksConfigurationException("'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                this.recordMetaData.assertValidFieldName(this.bindMapKeyField);
                Bean mapBean = new Bean(LinkedHashMap.class, this.bindBeanId, "#document");
                Bean recordBean = new Bean(this.bindBeanClass, RECORD_BEAN, this.recordElementName);
                MapBindingWiringVisitor wiringVisitor = new MapBindingWiringVisitor(this.bindMapKeyField, this.bindBeanId);
                this.addFieldBindings(recordBean);
                mapBean.addVisitors(visitorMap);
                recordBean.addVisitors(visitorMap);
                visitorMap.addVisitor(wiringVisitor, this.recordElementName, null, false);
            } else {
                Bean bean = new Bean(this.bindBeanClass, this.bindBeanId, this.recordElementName);
                this.addFieldBindings(bean);
                bean.addVisitors(visitorMap);
            }
        }
    }

    @Initialize
    public final void fixupRecordDelimiter() {
        if (this.recordDelimiter == null) {
            return;
        }
        if (this.recordDelimiter.startsWith("regex:")) {
            this.recordDelimiterPattern = Pattern.compile(this.recordDelimiter.substring("regex:".length()), 40);
        } else {
            this.recordDelimiter = VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter, "\\n", '\n');
            this.recordDelimiter = VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter, "\\r", '\r');
            this.recordDelimiter = VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter, "\\t", '\t');
            this.recordDelimiter = XmlUtil.removeEntities(this.recordDelimiter);
        }
    }

    @Initialize
    public final void buildRecordMetaData() {
        if (this.fields == null) {
            this.recordMetaData = new RecordMetaData(this.recordElementName, new ArrayList<FieldMetaData>(), true);
        } else {
            String[] recordDefs = this.fields.split("\\|");
            for (int i = 0; i < recordDefs.length; ++i) {
                recordDefs[i] = recordDefs[i].trim();
            }
            if (recordDefs.length == 1) {
                recordDefs[0] = recordDefs[0].trim();
                if (SINGLE_RECORD_PATTERN.matcher(recordDefs[0]).matches()) {
                    this.recordMetaData = this.buildRecordMetaData(this.recordElementName, recordDefs[0].split(","));
                    return;
                }
                this.recordMetaData = this.buildMultiRecordMetaData(recordDefs[0]);
                if (this.recordMetaData == null) {
                    throw new SmooksConfigurationException("Unsupported fields definition '" + this.fields + "'.  Must match either the single ('" + SINGLE_RECORD_PATTERN.pattern() + "') or multi ('" + MULTI_RECORD_PATTERN.pattern() + "') record pattern.");
                }
            } else {
                for (String recordDef : recordDefs) {
                    RecordMetaData multiRecordMetaData = this.buildMultiRecordMetaData(recordDef = recordDef.trim());
                    if (multiRecordMetaData == null) {
                        throw new SmooksConfigurationException("Unsupported fields definition '" + recordDef + "'.  Must match the multi record pattern ('" + MULTI_RECORD_PATTERN.pattern() + "') .");
                    }
                    if (this.recordMetaDataMap == null) {
                        this.recordMetaDataMap = new HashMap<String, RecordMetaData>();
                    }
                    this.recordMetaDataMap.put(multiRecordMetaData.getName(), multiRecordMetaData);
                }
            }
        }
    }

    public void readRecord(Reader recordReader, StringBuilder recordBuffer, int recordNumber) throws IOException {
        int c;
        recordBuffer.setLength(0);
        recordBuffer.append(this.overFlowFromLastRecord);
        RecordBoundaryLocator boundaryLocator = this.recordDelimiterPattern != null ? new RegexRecordBoundaryLocator(recordBuffer, recordNumber) : new SimpleRecordBoundaryLocator(recordBuffer, recordNumber);
        while ((c = recordReader.read()) != -1) {
            if (recordBuffer.length() == 0 && (c == 10 || c == 13)) continue;
            recordBuffer.append((char)c);
            if (!boundaryLocator.atEndOfRecord()) continue;
        }
        this.overFlowFromLastRecord = boundaryLocator.getOverflowCharacters();
    }

    private RecordMetaData buildMultiRecordMetaData(String recordDef) {
        Matcher matcher = MULTI_RECORD_PATTERN.matcher(recordDef);
        if (matcher.matches()) {
            return this.buildRecordMetaData(matcher.group(1), matcher.group(2).split(","));
        }
        return null;
    }

    private RecordMetaData buildRecordMetaData(String recordName, String[] fieldNames) {
        ArrayList<FieldMetaData> fieldsMetaData = new ArrayList<FieldMetaData>();
        for (int i = 0; i < fieldNames.length; ++i) {
            FieldMetaData fieldMetaData;
            String fieldSpec = fieldNames[i].trim();
            if (fieldSpec.equals("*")) {
                return new RecordMetaData(recordName, fieldsMetaData, true);
            }
            if (fieldSpec.indexOf(63) >= 0) {
                String fieldName = fieldSpec.substring(0, fieldSpec.indexOf(63));
                String functionDefinition = fieldSpec.substring(fieldSpec.indexOf(63) + 1);
                fieldMetaData = new FieldMetaData(fieldName);
                if (functionDefinition.length() != 0) {
                    fieldMetaData.setStringFunctionExecutor(StringFunctionExecutor.getInstance(functionDefinition));
                }
            } else {
                fieldMetaData = new FieldMetaData(fieldSpec);
            }
            fieldsMetaData.add(fieldMetaData);
            if (!fieldMetaData.ignore() || fieldMetaData.getIgnoreCount() <= 1 || fieldMetaData.getIgnoreCount() >= Integer.MAX_VALUE) continue;
            for (int ii = 0; ii < fieldMetaData.getIgnoreCount() - 1; ++ii) {
                fieldsMetaData.add(new FieldMetaData("$ignore$"));
            }
        }
        return new RecordMetaData(recordName, fieldsMetaData);
    }

    private void addFieldBindings(Bean bean) {
        for (FieldMetaData fieldMetaData : this.recordMetaData.getFields()) {
            if (fieldMetaData.ignore()) continue;
            bean.bindTo(fieldMetaData.getName(), this.recordElementName + "/" + fieldMetaData.getName());
        }
    }

    private static String removeSpecialCharEncodeString(String string, String encodedString, char replaceChar) {
        return string.replace(encodedString, new String(new char[]{replaceChar}));
    }

    static {
        unknownVRecordType.getFields().add(new FieldMetaData("value"));
    }

    private abstract class RecordBoundaryLocator {
        protected StringBuilder recordBuffer;
        protected int recordNumber;

        protected RecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            this.recordBuffer = recordBuffer;
            this.recordNumber = recordNumber;
        }

        abstract boolean atEndOfRecord();

        abstract String getOverflowCharacters();
    }

    private class RegexRecordBoundaryLocator
    extends RecordBoundaryLocator {
        private int startFindIndex;
        private int endRecordIndex;
        private String overFlow;

        protected RegexRecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            super(recordBuffer, recordNumber);
            this.overFlow = "";
            this.startFindIndex = recordBuffer.length();
        }

        boolean atEndOfRecord() {
            Matcher matcher = VariableFieldRecordParserFactory.this.recordDelimiterPattern.matcher(this.recordBuffer);
            if (matcher.find(this.startFindIndex)) {
                if (this.recordNumber == 1 && this.startFindIndex == 0) {
                    this.startFindIndex = matcher.end();
                    return false;
                }
                this.endRecordIndex = matcher.start();
                this.overFlow = this.recordBuffer.substring(this.endRecordIndex);
                this.recordBuffer.setLength(this.endRecordIndex);
                return true;
            }
            return false;
        }

        String getOverflowCharacters() {
            return this.overFlow;
        }
    }

    private class SimpleRecordBoundaryLocator
    extends RecordBoundaryLocator {
        private SimpleRecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            super(recordBuffer, recordNumber);
        }

        boolean atEndOfRecord() {
            int builderLen = this.recordBuffer.length();
            char lastChar = this.recordBuffer.charAt(builderLen - 1);
            if (VariableFieldRecordParserFactory.this.recordDelimiter != null) {
                int stringLen = VariableFieldRecordParserFactory.this.recordDelimiter.length();
                if (builderLen < stringLen) {
                    return false;
                }
                int stringIndx = 0;
                for (int i = builderLen - stringLen; i < builderLen; ++i) {
                    if (this.recordBuffer.charAt(i) != VariableFieldRecordParserFactory.this.recordDelimiter.charAt(stringIndx)) {
                        return false;
                    }
                    ++stringIndx;
                }
                if (!VariableFieldRecordParserFactory.this.keepDelimiter) {
                    this.recordBuffer.setLength(builderLen - stringLen);
                }
                return true;
            }
            if (lastChar == '\r' || lastChar == '\n') {
                if (!VariableFieldRecordParserFactory.this.keepDelimiter) {
                    this.recordBuffer.setLength(builderLen - 1);
                }
                return true;
            }
            return false;
        }

        String getOverflowCharacters() {
            return "";
        }
    }

    private class MapBindingWiringVisitor
    implements DOMVisitAfter,
    SAXVisitAfter,
    Consumer {
        private MVELExpressionEvaluator keyExtractor = new MVELExpressionEvaluator();
        private String mapBindingKey;

        private MapBindingWiringVisitor(String bindKeyField, String mapBindingKey) {
            this.keyExtractor.setExpression("recordBean." + bindKeyField);
            this.mapBindingKey = mapBindingKey;
        }

        public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
            this.wireObject(executionContext);
        }

        public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            this.wireObject(executionContext);
        }

        private void wireObject(ExecutionContext executionContext) {
            BeanContext beanContext = executionContext.getBeanContext();
            Map<String, Object> beanMap = beanContext.getBeanMap();
            Object key = this.keyExtractor.getValue(beanMap);
            Map map = (Map)beanContext.getBean(this.mapBindingKey);
            Object record = beanContext.getBean(VariableFieldRecordParserFactory.RECORD_BEAN);
            map.put(key, record);
        }

        public boolean consumes(Object object) {
            return this.keyExtractor.getExpression().indexOf(object.toString()) != -1;
        }
    }
}

