/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.strategy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.AbstractPrefillPool;
import org.jboss.jca.core.connectionmanager.pool.strategy.SubjectKey;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SubjectFactory;

public class PoolBySubject
extends AbstractPrefillPool {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)PoolBySubject.class.getName());

    public PoolBySubject(ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools) {
        super(mcf, pc, noTxSeparatePools);
    }

    @Override
    protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx) throws ResourceException {
        return new SubjectKey(subject, separateNoTx);
    }

    @Override
    public boolean testConnection() {
        try {
            ConnectionManager cm = (ConnectionManager)this.getConnectionListenerFactory();
            ManagedConnectionFactory mcf = this.getManagedConnectionFactory();
            Subject subject = this.createSubject(cm.getSubjectFactory(), cm.getSecurityDomain(), mcf);
            if (subject != null) {
                return this.internalTestConnection(subject);
            }
        }
        catch (Throwable t) {
            log.debug("Error during testConnection: " + t.getMessage(), t);
        }
        return false;
    }

    protected Subject createSubject(final SubjectFactory subjectFactory, final String securityDomain, final ManagedConnectionFactory mcf) {
        if (subjectFactory == null) {
            throw new IllegalArgumentException("SubjectFactory is null");
        }
        if (securityDomain == null) {
            throw new IllegalArgumentException("SecurityDomain is null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                try {
                    Subject subject;
                    Set<PasswordCredential> pcs;
                    if (SecurityContextAssociation.getSecurityContext() == null) {
                        SecurityContext securityContext = SecurityContextFactory.createSecurityContext((String)securityDomain);
                        SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
                        Subject unauthenticated = new Subject();
                        securityContext.getSubjectInfo().setAuthenticatedSubject(unauthenticated);
                    }
                    if ((pcs = (subject = subjectFactory.createSubject(securityDomain)).getPrivateCredentials(PasswordCredential.class)) != null && pcs.size() > 0) {
                        for (PasswordCredential pc : pcs) {
                            pc.setManagedConnectionFactory(mcf);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Subject=" + subject);
                    }
                    return subject;
                }
                catch (Throwable t) {
                    log.exceptionDuringCreateSubject(t.getMessage(), t);
                    return null;
                }
            }
        });
    }

    @Override
    public CoreLogger getLogger() {
        return log;
    }
}

