/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.validator;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.logging.Logger;

public class ConnectionValidator {
    private static CoreLogger logger = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ConnectionValidator.class.getName());
    private static final String VALIDATOR_THREAD_NAME = "JBossConnectionValidator";
    private CopyOnWriteArrayList<ManagedConnectionPool> registeredPools = new CopyOnWriteArrayList();
    private ExecutorService executorService = null;
    private static ConnectionValidator instance = new ConnectionValidator();
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private Lock lock = new ReentrantLock(true);
    private Condition condition = this.lock.newCondition();

    private ConnectionValidator() {
        this.executorService = Executors.newSingleThreadExecutor(new ValidatorThreadFactory());
        this.executorService.execute(new JBossConnectionValidator());
    }

    public static void registerPool(ManagedConnectionPool mcp, long interval) {
        instance.internalRegisterPool(mcp, interval);
    }

    public static void unregisterPool(ManagedConnectionPool mcp) {
        instance.internalUnregisterPool(mcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegisterPool(ManagedConnectionPool mcp, long interval) {
        try {
            this.lock.lock();
            this.registeredPools.addIfAbsent(mcp);
            if (interval > 1L && interval / 2L < this.interval) {
                this.interval = interval / 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    this.next = maybeNext;
                    if (logger.isDebugEnabled()) {
                        logger.debug("internalRegisterPool: about to notify thread: old next: " + this.next + ", new next: " + maybeNext);
                    }
                    this.condition.signal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void internalUnregisterPool(ManagedConnectionPool mcp) {
        this.registeredPools.remove(mcp);
        if (this.registeredPools.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("internalUnregisterPool: setting interval to Long.MAX_VALUE");
            }
            this.interval = Long.MAX_VALUE;
        }
    }

    private void setupContextClassLoader() {
        ClassLoader cl = ConnectionValidator.class.getClassLoader();
        if (cl == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Thread.currentThread().setContextClassLoader(cl);
            return;
        }
        AccessController.doPrivileged(new ClassLoaderAction(cl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBackgroundThread() {
        try {
            ConnectionValidator.instance.lock.lock();
        }
        finally {
            ConnectionValidator.instance.lock.unlock();
        }
    }

    static /* synthetic */ void access$200(ConnectionValidator x0) {
        x0.setupContextClassLoader();
    }

    static /* synthetic */ Lock access$300(ConnectionValidator x0) {
        return x0.lock;
    }

    static /* synthetic */ ConnectionValidator access$400() {
        return instance;
    }

    static /* synthetic */ long access$500(ConnectionValidator x0) {
        return x0.interval;
    }

    static /* synthetic */ Condition access$600(ConnectionValidator x0) {
        return x0.condition;
    }

    static /* synthetic */ CoreLogger access$700() {
        return logger;
    }

    static /* synthetic */ CopyOnWriteArrayList access$800(ConnectionValidator x0) {
        return x0.registeredPools;
    }

    static /* synthetic */ long access$902(ConnectionValidator x0, long x1) {
        x0.next = x1;
        return x0.next;
    }

    static /* synthetic */ long access$900(ConnectionValidator x0) {
        return x0.next;
    }

    private class JBossConnectionValidator
    implements Runnable {
        private JBossConnectionValidator() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class ValidatorThreadFactory
    implements ThreadFactory {
        private ValidatorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, ConnectionValidator.VALIDATOR_THREAD_NAME);
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class ClassLoaderAction
    implements PrivilegedAction<Object> {
        private ClassLoader classLoader;

        public ClassLoaderAction(ClassLoader cl) {
            this.classLoader = cl;
        }

        @Override
        public Object run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }
}

