/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.rar;

import java.lang.ref.WeakReference;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.bv.BeanValidationUtil;
import org.jboss.jca.core.spi.rar.Endpoint;
import org.jboss.logging.Messages;

public class EndpointImpl
implements Endpoint {
    private WeakReference<ResourceAdapter> ra;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);

    EndpointImpl(WeakReference<ResourceAdapter> ra) {
        this.ra = ra;
    }

    public void activate(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (endpointFactory == null) {
            throw new IllegalArgumentException("MessageEndpointFactory is null");
        }
        if (spec == null) {
            throw new IllegalArgumentException("ActivationSpec is null");
        }
        ResourceAdapter rar = (ResourceAdapter)this.ra.get();
        if (rar == null) {
            throw new ResourceException(bundle.resourceAdapterInstanceNotActive());
        }
        spec.validate();
        Validator validator = BeanValidationUtil.createValidator();
        Set errors = validator.validate((Object)spec, new Class[]{Default.class});
        if (errors != null && errors.size() > 0) {
            throw new ResourceException(bundle.validationException(), (Throwable)new ConstraintViolationException(errors));
        }
        rar.endpointActivation(endpointFactory, spec);
    }

    public void deactivate(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (endpointFactory == null) {
            throw new IllegalArgumentException("MessageEndpointFactory is null");
        }
        if (spec == null) {
            throw new IllegalArgumentException("ActivationSpec is null");
        }
        ResourceAdapter rar = (ResourceAdapter)this.ra.get();
        if (rar == null) {
            throw new ResourceException(bundle.resourceAdapterInstanceNotActive());
        }
        rar.endpointDeactivation(endpointFactory, spec);
    }
}

