/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.Service;
import org.switchyard.admin.base.BaseSwitchYard;

public class BaseApplication
implements Application {
    private BaseSwitchYard _switchYard;
    private QName _name;
    private Map<QName, Service> _services;

    public BaseApplication(BaseSwitchYard switchYard, QName name, List<Service> services) {
        this(switchYard, name);
        if (services != null) {
            for (Service service : services) {
                this._services.put(service.getName(), service);
            }
        }
    }

    public BaseApplication(BaseSwitchYard switchYard, QName name) {
        this._switchYard = switchYard;
        this._name = name;
        this._services = new LinkedHashMap<QName, Service>();
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public List<Service> getServices() {
        if (this._services == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Service>(this._services.values());
    }

    public void setServices(List<Service> services) {
        this._services = new LinkedHashMap<QName, Service>();
        for (Service service : services) {
            this._services.put(service.getName(), service);
        }
    }

    protected void addService(Service service) {
        this._services.put(service.getName(), service);
        this._switchYard.addService(service);
    }

    protected Service removeService(QName serviceName) {
        Service service = this._services.remove(serviceName);
        if (service != null) {
            this._switchYard.removeService(service);
        }
        return service;
    }
}

