/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.admin.Component;
import org.switchyard.admin.base.BaseApplication;
import org.switchyard.admin.base.BaseService;
import org.switchyard.admin.base.BaseSwitchYard;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.DeploymentListener;

public class SwitchYardBuilder
implements DeploymentListener {
    private static Logger _log = Logger.getLogger(SwitchYardBuilder.class);
    private BaseSwitchYard _switchYard;

    public SwitchYardBuilder(BaseSwitchYard switchYard) {
        this._switchYard = switchYard;
    }

    public void initializing(AbstractDeployment deployment) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"initializing() received deployment with null application name.");
            return;
        }
        this._switchYard.addApplication(new BaseApplication(this._switchYard, applicationName));
    }

    public void initialized(AbstractDeployment deployment) {
    }

    public void initializationFailed(AbstractDeployment deployment, Throwable throwable) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"initializationFailed() received deployment with null application name.");
            return;
        }
        this._switchYard.removeApplication(applicationName);
    }

    public void starting(AbstractDeployment deployment) {
    }

    public void started(AbstractDeployment deployment) {
    }

    public void startFailed(AbstractDeployment deployment, Throwable throwable) {
    }

    public void stopping(AbstractDeployment deployment) {
    }

    public void stopped(AbstractDeployment deployment) {
    }

    public void stopFailed(AbstractDeployment deployment, Throwable throwable) {
    }

    public void destroying(AbstractDeployment deployment) {
    }

    public void destroyed(AbstractDeployment deployment) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"destroyed() received deployment with null application name.");
            return;
        }
        this._switchYard.removeApplication(applicationName);
    }

    public void serviceDeployed(AbstractDeployment deployment, CompositeServiceModel serviceModel) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"serviceDeployed() received deployment with null application name.");
            return;
        }
        BaseApplication application = (BaseApplication)this._switchYard.findApplication(applicationName);
        QName name = serviceModel.getQName();
        String interfaceName = this.getServiceInterface(serviceModel);
        Component implementation = this.getServiceImplementation(serviceModel);
        ArrayList<Component> gateways = new ArrayList<Component>();
        for (BindingModel binding : serviceModel.getBindings()) {
            Component component = this._switchYard.findComponent(binding.getType());
            if (component == null) continue;
            gateways.add(component);
        }
        BaseService service = new BaseService(name, interfaceName, application, implementation, gateways);
        application.addService(service);
    }

    public void serviceUndeployed(AbstractDeployment deployment, QName serviceName) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"serviceUndeployed() received deployment with null application name.");
            return;
        }
        BaseApplication application = (BaseApplication)this._switchYard.findApplication(applicationName);
        application.removeService(serviceName);
    }

    private Component getServiceImplementation(CompositeServiceModel compositeService) {
        ComponentModel componentModel = compositeService.getComponent();
        if (componentModel == null) {
            return null;
        }
        ComponentImplementationModel componentImplementationModel = componentModel.getImplementation();
        if (componentImplementationModel == null) {
            return null;
        }
        return this._switchYard.findComponent(componentImplementationModel.getType());
    }

    private String getServiceInterface(CompositeServiceModel compositeService) {
        InterfaceModel interfaceModel = compositeService.getInterface();
        if (interfaceModel != null) {
            return interfaceModel.getInterface();
        }
        ComponentServiceModel componentServiceModel = compositeService.getComponentService();
        if (componentServiceModel == null) {
            return null;
        }
        if (componentServiceModel.getInterface() == null) {
            return null;
        }
        return componentServiceModel.getInterface().getInterface();
    }
}

